/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode.iterator;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.iterator.IMNodeIterator;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.template.Template;

public abstract class AbstractTraverserIterator
implements IMNodeIterator {
    private final IMNodeIterator directChildrenIterator;
    private Iterator<IMNode> templateChildrenIterator;
    protected IMNode nextMatchedNode;
    protected boolean usingDirectChildrenIterator = true;
    private boolean skipPreDeletedSchema = false;

    protected AbstractTraverserIterator(IMTreeStore store, IEntityMNode parent, Map<Integer, Template> templateMap) throws MetadataException {
        Template template;
        this.directChildrenIterator = store.getChildrenIterator(parent);
        if (templateMap != null && parent.isUseTemplate() && (template = this.getActivatedSchemaTemplate(parent, templateMap)) != null) {
            this.templateChildrenIterator = template.getDirectNodes().iterator();
        }
    }

    public void setSkipPreDeletedSchema(boolean skipPreDeletedSchema) {
        this.skipPreDeletedSchema = skipPreDeletedSchema;
    }

    private Template getActivatedSchemaTemplate(IEntityMNode node, Map<Integer, Template> templateMap) {
        if (node.getSchemaTemplateId() != -1) {
            if (this.skipPreDeletedSchema && node.getAsEntityMNode().isPreDeactivateTemplate()) {
                return null;
            }
            return templateMap.get(node.getSchemaTemplateId());
        }
        throw new IllegalStateException(String.format("There should be a template mounted on any ancestor of the node [%s] usingTemplate.", node.getFullPath()));
    }

    @Override
    public boolean hasNext() {
        while (this.nextMatchedNode == null) {
            if (this.directChildrenIterator.hasNext()) {
                this.nextMatchedNode = (IMNode)this.directChildrenIterator.next();
                this.usingDirectChildrenIterator = true;
            } else if (this.templateChildrenIterator != null && this.templateChildrenIterator.hasNext()) {
                this.nextMatchedNode = this.templateChildrenIterator.next();
                this.usingDirectChildrenIterator = false;
            } else {
                return false;
            }
            if (!this.skipPreDeletedSchema || !this.nextMatchedNode.isMeasurement() || !this.nextMatchedNode.getAsMeasurementMNode().isPreDeleted()) continue;
            this.nextMatchedNode = null;
        }
        return true;
    }

    @Override
    public IMNode next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        IMNode result = this.nextMatchedNode;
        this.nextMatchedNode = null;
        return result;
    }

    @Override
    public void close() {
        this.directChildrenIterator.close();
        this.templateChildrenIterator = null;
    }
}

