/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode.estimator;

import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.estimator.IMNodeSizeEstimator;

public class BasicMNodSizeEstimator
implements IMNodeSizeEstimator {
    protected static final int NODE_BASE_SIZE = 92;
    protected static final int INTERNAL_NODE_BASE_SIZE = 97;
    protected static final int STORAGE_GROUP_NODE_BASE_SIZE = 16;
    protected static final int ENTITY_NODE_BASE_SIZE = 9;
    protected static final int MEASUREMENT_NODE_BASE_SIZE = 48;
    protected static final int ALIAS_BASE_SIZE = 52;

    @Override
    public int estimateSize(IMNode node) {
        int size = 92 + node.getName().length();
        if (node.isMeasurement()) {
            size += 48;
            IMeasurementMNode measurementMNode = node.getAsMeasurementMNode();
            if (measurementMNode.getAlias() != null) {
                size += 52 + measurementMNode.getAlias().length();
            }
        } else {
            size += 97;
            if (node.isStorageGroup()) {
                size += 16;
                size += node.getAsStorageGroupMNode().getFullPath().length();
            }
            if (node.isEntity()) {
                size += 9;
            }
        }
        return size;
    }
}

