/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.type;

import java.util.Arrays;
import java.util.Map;
import org.apache.iotdb.metrics.type.IMetric;

public interface HistogramSnapshot
extends IMetric {
    public double getValue(double var1);

    public double[] getValues();

    public int size();

    public double getMin();

    public double getMedian();

    public double getMean();

    public double getMax();

    @Override
    default public void constructValueMap(Map<String, Object> result) {
        result.put("max", this.getMax());
        result.put("sum", Arrays.stream(this.getValues()).sum());
        result.put("p0", this.getValue(0.0));
        result.put("p50", this.getValue(0.5));
        result.put("p75", this.getValue(0.75));
        result.put("p99", this.getValue(0.99));
        result.put("p999", this.getValue(0.999));
    }
}

