/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.cq;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.write.cq.ActiveCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.AddCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.DropCQPlan;
import org.apache.iotdb.confignode.manager.cq.CQScheduleTask;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.cq.CreateCQState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateCQProcedure
extends AbstractNodeProcedure<CreateCQState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateCQProcedure.class);
    private static final int RETRY_THRESHOLD = 5;
    private final ScheduledExecutorService executor;
    private TCreateCQReq req;
    private String md5;
    private long firstExecutionTime;

    public CreateCQProcedure(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public CreateCQProcedure(TCreateCQReq req, ScheduledExecutorService executor) {
        this.req = req;
        this.md5 = DigestUtils.md2Hex((String)req.cqId);
        this.executor = executor;
        this.firstExecutionTime = CQScheduleTask.getFirstExecutionTime(req.boundaryTime, req.everyInterval);
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, CreateCQState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        block19: {
            try {
                switch (state) {
                    case INIT: {
                        ConsensusWriteResponse response = env.getConfigManager().getConsensusManager().write(new AddCQPlan(this.req, this.md5, this.firstExecutionTime));
                        TSStatus res = response.getStatus();
                        if (res != null) {
                            if (res.code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                                LOGGER.debug("Finish init CQ {} successfully", (Object)this.req.cqId);
                                this.setNextState(CreateCQState.INACTIVE);
                                break;
                            }
                            if (res.code == TSStatusCode.CQ_AlREADY_EXIST.getStatusCode()) {
                                LOGGER.info("Failed to init CQ {} because such cq already exists", (Object)this.req.cqId);
                                this.setFailure(new ProcedureException((Throwable)new IoTDBException(res.message, res.code)));
                                return StateMachineProcedure.Flow.HAS_MORE_STATE;
                            }
                            LOGGER.warn("Failed to init CQ {} because of unknown reasons {}", (Object)this.req.cqId, (Object)res);
                            this.setFailure(new ProcedureException((Throwable)new IoTDBException(res.message, res.code)));
                            return StateMachineProcedure.Flow.HAS_MORE_STATE;
                        }
                        LOGGER.warn("Failed to init CQ {} because of unexpected exception: ", (Object)this.req.cqId, (Object)response.getException());
                        this.setFailure(new ProcedureException((Throwable)response.getException()));
                        return StateMachineProcedure.Flow.HAS_MORE_STATE;
                    }
                    case INACTIVE: {
                        CQScheduleTask cqScheduleTask = new CQScheduleTask(this.req, this.firstExecutionTime, this.md5, this.executor, env.getConfigManager());
                        cqScheduleTask.submitSelf();
                        this.setNextState(CreateCQState.SCHEDULED);
                        break;
                    }
                    case SCHEDULED: {
                        ConsensusWriteResponse response = env.getConfigManager().getConsensusManager().write(new ActiveCQPlan(this.req.cqId, this.md5));
                        TSStatus res = response.getStatus();
                        if (res != null) {
                            if (res.code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                                LOGGER.debug("Finish Scheduling CQ {} successfully", (Object)this.req.cqId);
                            } else if (res.code == TSStatusCode.NO_SUCH_CQ.getStatusCode()) {
                                LOGGER.warn("Failed to active CQ {} because of no such cq, detailed error message is {}", (Object)this.req.cqId, (Object)res.message);
                            } else if (res.code == TSStatusCode.CQ_ALREADY_ACTIVE.getStatusCode()) {
                                LOGGER.warn("Failed to active CQ {} because this cq has already been active", (Object)this.req.cqId);
                            } else {
                                LOGGER.warn("Failed to active CQ {} successfully because of unknown reasons {}", (Object)this.req.cqId, (Object)res);
                            }
                        } else {
                            LOGGER.warn("Failed to active CQ {} successfully because of unexpected exception: ", (Object)this.req.cqId, (Object)response.getException());
                        }
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown CreateCQState: " + (Object)((Object)state));
                    }
                }
            }
            catch (Throwable t) {
                if (this.isRollbackSupported(state)) {
                    LOGGER.error("Fail in CreateCQProcedure", t);
                    this.setFailure(new ProcedureException(t));
                }
                LOGGER.error("Retrievable error trying to create cq [{}], state [{}]", new Object[]{this.req.getCqId(), state, t});
                if (this.getCycles() <= 5) break block19;
                this.setFailure(new ProcedureException(String.format("Fail to create trigger [%s] at STATE [%s]", new Object[]{this.req.getCqId(), state})));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, CreateCQState state) throws IOException, InterruptedException, ProcedureException {
        switch (state) {
            case INIT: 
            case SCHEDULED: {
                break;
            }
            case INACTIVE: {
                LOGGER.info("Start [INACTIVE] rollback of CQ {}", (Object)this.req.cqId);
                ConsensusWriteResponse response = env.getConfigManager().getConsensusManager().write(new DropCQPlan(this.req.cqId, this.md5));
                TSStatus res = response.getStatus();
                if (res != null) {
                    if (res.code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        LOGGER.info("Finish [INACTIVE] rollback of CQ {} successfully", (Object)this.req.cqId);
                        break;
                    }
                    if (res.code == TSStatusCode.NO_SUCH_CQ.getStatusCode()) {
                        LOGGER.warn("Failed to do [INACTIVE] rollback of CQ {} because of no such cq, detailed error message is {}", (Object)this.req.cqId, (Object)res.message);
                        break;
                    }
                    LOGGER.warn("Failed to do [INACTIVE] rollback of CQ {} successfully because of unknown reasons {}", (Object)this.req.cqId, (Object)res);
                    break;
                }
                LOGGER.warn("Failed to do [INACTIVE] rollback of CQ {} successfully because of unexpected exception: ", (Object)this.req.cqId, (Object)response.getException());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CreateCQState: " + (Object)((Object)state));
            }
        }
    }

    @Override
    protected boolean isRollbackSupported(CreateCQState createCQState) {
        return createCQState == CreateCQState.INACTIVE;
    }

    @Override
    protected CreateCQState getState(int stateId) {
        return CreateCQState.values()[stateId];
    }

    @Override
    protected int getStateId(CreateCQState createCQState) {
        return createCQState.ordinal();
    }

    @Override
    protected CreateCQState getInitialState() {
        return CreateCQState.INIT;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.CREATE_CQ_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ThriftCommonsSerDeUtils.serializeTCreateCQReq((TCreateCQReq)this.req, (DataOutputStream)stream);
        ReadWriteIOUtils.write((String)this.md5, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.firstExecutionTime, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.req = ThriftCommonsSerDeUtils.deserializeTCreateCQReq((ByteBuffer)byteBuffer);
        this.md5 = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.firstExecutionTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCQProcedure that = (CreateCQProcedure)o;
        return this.firstExecutionTime == that.firstExecutionTime && Objects.equals(this.req, that.req) && Objects.equals(this.md5, that.md5);
    }

    public int hashCode() {
        return Objects.hash(this.req, this.md5, this.firstExecutionTime);
    }
}

