/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.partition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.cluster.RegionRoleType;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetNodePathsPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetOrCreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetOrCreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetSeriesSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetTimeSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionIdPlan;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.PreDeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.UpdateRegionLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.PollSpecificRegionMaintainTaskPlan;
import org.apache.iotdb.confignode.consensus.response.partition.DataPartitionResp;
import org.apache.iotdb.confignode.consensus.response.partition.GetRegionIdResp;
import org.apache.iotdb.confignode.consensus.response.partition.GetSeriesSlotListResp;
import org.apache.iotdb.confignode.consensus.response.partition.GetTimeSlotListResp;
import org.apache.iotdb.confignode.consensus.response.partition.RegionInfoListResp;
import org.apache.iotdb.confignode.consensus.response.partition.SchemaNodeManagementResp;
import org.apache.iotdb.confignode.consensus.response.partition.SchemaPartitionResp;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.exception.NoAvailableRegionGroupException;
import org.apache.iotdb.confignode.exception.NotEnoughDataNodeException;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.ProcedureManager;
import org.apache.iotdb.confignode.manager.consensus.ConsensusManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.partition.RegionGroupExtensionPolicy;
import org.apache.iotdb.confignode.manager.partition.RegionGroupStatus;
import org.apache.iotdb.confignode.manager.partition.heartbeat.RegionGroupCache;
import org.apache.iotdb.confignode.manager.schema.ClusterSchemaManager;
import org.apache.iotdb.confignode.persistence.partition.PartitionInfo;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionCreateTask;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionDeleteTask;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionMaintainTask;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionMaintainType;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdReq;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.response.ConsensusReadResponse;
import org.apache.iotdb.mpp.rpc.thrift.TCreateDataRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateSchemaRegionReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionManager.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final RegionGroupExtensionPolicy SCHEMA_REGION_GROUP_EXTENSION_POLICY = CONF.getSchemaRegionGroupExtensionPolicy();
    private static final RegionGroupExtensionPolicy DATA_REGION_GROUP_EXTENSION_POLICY = CONF.getDataRegionGroupExtensionPolicy();
    private final IManager configManager;
    private final PartitionInfo partitionInfo;
    private SeriesPartitionExecutor executor;
    private final Object scheduleMonitor = new Object();
    private static final int REGION_MAINTAINER_WORK_INTERVAL = 10;
    private final ScheduledExecutorService regionMaintainer;
    private Future<?> currentRegionMaintainerFuture;
    private final Map<TConsensusGroupId, RegionGroupCache> regionGroupCacheMap;

    public PartitionManager(IManager configManager, PartitionInfo partitionInfo) {
        this.configManager = configManager;
        this.partitionInfo = partitionInfo;
        this.regionMaintainer = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"IoTDB-Region-Maintainer");
        this.regionGroupCacheMap = new ConcurrentHashMap<TConsensusGroupId, RegionGroupCache>();
        this.setSeriesPartitionExecutor();
    }

    private void setSeriesPartitionExecutor() {
        this.executor = SeriesPartitionExecutor.getSeriesPartitionExecutor((String)CONF.getSeriesPartitionExecutorClass(), (int)CONF.getSeriesSlotNum());
    }

    public DataSet getSchemaPartition(GetSchemaPartitionPlan req) {
        return this.getConsensusManager().read(req).getDataset();
    }

    public DataSet getDataPartition(GetDataPartitionPlan req) {
        return this.getConsensusManager().read(req).getDataset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaPartitionResp getOrCreateSchemaPartition(GetOrCreateSchemaPartitionPlan req) {
        for (String database : req.getPartitionSlotsMap().keySet()) {
            if (this.isDatabaseExist(database)) continue;
            return new SchemaPartitionResp(new TSStatus(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()).setMessage(String.format("Create SchemaPartition failed because the database: %s is not exists", database)), false, null);
        }
        SchemaPartitionResp resp = (SchemaPartitionResp)this.getSchemaPartition(req);
        if (resp.isAllPartitionsExist()) {
            return resp;
        }
        PartitionManager partitionManager = this;
        synchronized (partitionManager) {
            Map<String, SchemaPartitionTable> assignedSchemaPartition;
            Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlotsMap = this.partitionInfo.filterUnassignedSchemaPartitionSlots(req.getPartitionSlotsMap());
            ConcurrentHashMap<String, Integer> unassignedSchemaPartitionSlotsCountMap = new ConcurrentHashMap<String, Integer>();
            unassignedSchemaPartitionSlotsMap.forEach((storageGroup, unassignedSchemaPartitionSlots) -> unassignedSchemaPartitionSlotsCountMap.put((String)storageGroup, unassignedSchemaPartitionSlots.size()));
            TSStatus status = this.extendRegionGroupIfNecessary(unassignedSchemaPartitionSlotsCountMap, TConsensusGroupType.SchemaRegion);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                return resp;
            }
            status = this.getConsensusManager().confirmLeader();
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                return resp;
            }
            try {
                assignedSchemaPartition = this.getLoadManager().allocateSchemaPartition(unassignedSchemaPartitionSlotsMap);
            }
            catch (NoAvailableRegionGroupException e) {
                LOGGER.error("Create SchemaPartition failed because: ", (Throwable)e);
                resp.setStatus(new TSStatus(TSStatusCode.NO_AVAILABLE_REGION_GROUP.getStatusCode()).setMessage(e.getMessage()));
                return resp;
            }
            CreateSchemaPartitionPlan createPlan = new CreateSchemaPartitionPlan();
            createPlan.setAssignedSchemaPartition(assignedSchemaPartition);
            this.getConsensusManager().write(createPlan);
        }
        resp = (SchemaPartitionResp)this.getSchemaPartition(req);
        if (!resp.isAllPartitionsExist()) {
            LOGGER.error("Lacked some SchemaPartition allocation result in the response of getOrCreateDataPartition method");
            resp.setStatus(new TSStatus(TSStatusCode.LACK_PARTITION_ALLOCATION.getStatusCode()).setMessage("Lacked some SchemaPartition allocation result in the response"));
            return resp;
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataPartitionResp getOrCreateDataPartition(GetOrCreateDataPartitionPlan req) {
        for (String database : req.getPartitionSlotsMap().keySet()) {
            if (this.isDatabaseExist(database)) continue;
            return new DataPartitionResp(new TSStatus(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()).setMessage(String.format("Create DataPartition failed because the database: %s is not exists", database)), false, null);
        }
        DataPartitionResp resp = (DataPartitionResp)this.getDataPartition(req);
        if (resp.isAllPartitionsExist()) {
            return resp;
        }
        PartitionManager partitionManager = this;
        synchronized (partitionManager) {
            Map<String, DataPartitionTable> assignedDataPartition;
            Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> unassignedDataPartitionSlotsMap = this.partitionInfo.filterUnassignedDataPartitionSlots(req.getPartitionSlotsMap());
            ConcurrentHashMap<String, Integer> unassignedDataPartitionSlotsCountMap = new ConcurrentHashMap<String, Integer>();
            unassignedDataPartitionSlotsMap.forEach((storageGroup, unassignedDataPartitionSlots) -> unassignedDataPartitionSlotsCountMap.put((String)storageGroup, unassignedDataPartitionSlots.size()));
            TSStatus status = this.extendRegionGroupIfNecessary(unassignedDataPartitionSlotsCountMap, TConsensusGroupType.DataRegion);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                return resp;
            }
            status = this.getConsensusManager().confirmLeader();
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                return resp;
            }
            try {
                assignedDataPartition = this.getLoadManager().allocateDataPartition(unassignedDataPartitionSlotsMap);
            }
            catch (NoAvailableRegionGroupException e) {
                LOGGER.error("Create DataPartition failed because: ", (Throwable)e);
                resp.setStatus(new TSStatus(TSStatusCode.NO_AVAILABLE_REGION_GROUP.getStatusCode()).setMessage(e.getMessage()));
                return resp;
            }
            CreateDataPartitionPlan createPlan = new CreateDataPartitionPlan();
            createPlan.setAssignedDataPartition(assignedDataPartition);
            this.getConsensusManager().write(createPlan);
        }
        resp = (DataPartitionResp)this.getDataPartition(req);
        if (!resp.isAllPartitionsExist()) {
            LOGGER.error("Lacked some DataPartition allocation result in the response of getOrCreateDataPartition method");
            resp.setStatus(new TSStatus(TSStatusCode.LACK_PARTITION_ALLOCATION.getStatusCode()).setMessage("Lacked some DataPartition allocation result in the response"));
            return resp;
        }
        return resp;
    }

    private TSStatus extendRegionGroupIfNecessary(Map<String, Integer> unassignedPartitionSlotsCountMap, TConsensusGroupType consensusGroupType) {
        TSStatus result = new TSStatus();
        try {
            if (TConsensusGroupType.SchemaRegion.equals((Object)consensusGroupType)) {
                switch (SCHEMA_REGION_GROUP_EXTENSION_POLICY) {
                    case CUSTOM: {
                        return this.customExtendRegionGroupIfNecessary(unassignedPartitionSlotsCountMap, consensusGroupType);
                    }
                }
                return this.autoExtendRegionGroupIfNecessary(unassignedPartitionSlotsCountMap, consensusGroupType);
            }
            switch (DATA_REGION_GROUP_EXTENSION_POLICY) {
                case CUSTOM: {
                    return this.customExtendRegionGroupIfNecessary(unassignedPartitionSlotsCountMap, consensusGroupType);
                }
            }
            return this.autoExtendRegionGroupIfNecessary(unassignedPartitionSlotsCountMap, consensusGroupType);
        }
        catch (NotEnoughDataNodeException e) {
            String prompt = "ConfigNode failed to extend Region because there are not enough DataNodes";
            LOGGER.error(prompt);
            result.setCode(TSStatusCode.NO_ENOUGH_DATANODE.getStatusCode());
            result.setMessage(prompt);
        }
        catch (DatabaseNotExistsException e) {
            String prompt = "ConfigNode failed to extend Region because some StorageGroup doesn't exist.";
            LOGGER.error(prompt);
            result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode());
            result.setMessage(prompt);
        }
        return result;
    }

    private TSStatus customExtendRegionGroupIfNecessary(Map<String, Integer> unassignedPartitionSlotsCountMap, TConsensusGroupType consensusGroupType) throws DatabaseNotExistsException, NotEnoughDataNodeException {
        ConcurrentHashMap<String, Integer> allotmentMap = new ConcurrentHashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : unassignedPartitionSlotsCountMap.entrySet()) {
            String database = entry.getKey();
            int minRegionGroupNum = this.getClusterSchemaManager().getMinRegionGroupNum(database, consensusGroupType);
            int allocatedRegionGroupCount = this.partitionInfo.getRegionGroupCount(database, consensusGroupType);
            if (allocatedRegionGroupCount >= minRegionGroupNum) continue;
            allotmentMap.put(database, minRegionGroupNum - allocatedRegionGroupCount);
        }
        return this.generateAndAllocateRegionGroups(allotmentMap, consensusGroupType);
    }

    private TSStatus autoExtendRegionGroupIfNecessary(Map<String, Integer> unassignedPartitionSlotsCountMap, TConsensusGroupType consensusGroupType) throws NotEnoughDataNodeException, DatabaseNotExistsException {
        ConcurrentHashMap<String, Integer> allotmentMap = new ConcurrentHashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : unassignedPartitionSlotsCountMap.entrySet()) {
            int delta;
            String database = entry.getKey();
            int unassignedPartitionSlotsCount = entry.getValue();
            float allocatedRegionGroupCount = this.partitionInfo.getRegionGroupCount(database, consensusGroupType);
            float slotCount = (float)this.partitionInfo.getAssignedSeriesPartitionSlotsCount(database) + (float)unassignedPartitionSlotsCount;
            float maxRegionGroupCount = this.getClusterSchemaManager().getMaxRegionGroupNum(database, consensusGroupType);
            float maxSlotCount = CONF.getSeriesSlotNum();
            int minRegionGroupNum = this.getClusterSchemaManager().getMinRegionGroupNum(database, consensusGroupType);
            if (allocatedRegionGroupCount < (float)minRegionGroupNum) {
                delta = (int)Math.min((float)unassignedPartitionSlotsCount, (float)minRegionGroupNum - allocatedRegionGroupCount);
                allotmentMap.put(database, delta);
                continue;
            }
            if (allocatedRegionGroupCount < maxRegionGroupCount && slotCount / allocatedRegionGroupCount > maxSlotCount / maxRegionGroupCount) {
                delta = Math.min((int)(maxRegionGroupCount - allocatedRegionGroupCount), Math.max(1, (int)Math.ceil(slotCount * maxRegionGroupCount / maxSlotCount - allocatedRegionGroupCount)));
                allotmentMap.put(database, delta);
                continue;
            }
            if (allocatedRegionGroupCount != (float)this.filterRegionGroupThroughStatus(database, RegionGroupStatus.Disabled).size() || !(allocatedRegionGroupCount < maxRegionGroupCount)) continue;
            allotmentMap.put(database, 1);
        }
        return this.generateAndAllocateRegionGroups(allotmentMap, consensusGroupType);
    }

    private TSStatus generateAndAllocateRegionGroups(Map<String, Integer> allotmentMap, TConsensusGroupType consensusGroupType) throws NotEnoughDataNodeException, DatabaseNotExistsException {
        if (!allotmentMap.isEmpty()) {
            CreateRegionGroupsPlan createRegionGroupsPlan = this.getLoadManager().allocateRegionGroups(allotmentMap, consensusGroupType);
            LOGGER.info("[CreateRegionGroups] Starting to create the following RegionGroups:");
            createRegionGroupsPlan.planLog(LOGGER);
            return this.getProcedureManager().createRegionGroups(consensusGroupType, createRegionGroupsPlan);
        }
        return RpcUtils.SUCCESS_STATUS;
    }

    public TConsensusGroupId getPrecededDataPartition(String storageGroup, TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot, long timePartitionInterval) {
        return this.partitionInfo.getPrecededDataPartition(storageGroup, seriesPartitionSlot, timePartitionSlot, timePartitionInterval);
    }

    public Set<TDataNodeLocation> getDatabaseRelatedDataNodes(String database, TConsensusGroupType type) {
        return this.partitionInfo.getDatabaseRelatedDataNodes(database, type);
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getAllReplicaSetsMap(TConsensusGroupType type) {
        return this.partitionInfo.getAllReplicaSets(type).stream().collect(Collectors.toMap(TRegionReplicaSet::getRegionId, regionReplicaSet -> regionReplicaSet));
    }

    public List<TRegionReplicaSet> getAllReplicaSets() {
        return this.partitionInfo.getAllReplicaSets();
    }

    public List<TRegionReplicaSet> getAllReplicaSets(TConsensusGroupType type) {
        return this.partitionInfo.getAllReplicaSets(type);
    }

    public List<TRegionReplicaSet> getAllReplicaSets(String database) {
        return this.partitionInfo.getAllReplicaSets(database);
    }

    public int getRegionCount(int dataNodeId, TConsensusGroupType type) {
        return this.partitionInfo.getRegionCount(dataNodeId, type);
    }

    public int getRegionGroupCount(String database, TConsensusGroupType type) throws DatabaseNotExistsException {
        return this.partitionInfo.getRegionGroupCount(database, type);
    }

    public boolean isDatabaseExist(String database) {
        return this.partitionInfo.isDatabaseExisted(database);
    }

    public List<PartialPath> filterUnExistDatabases(List<PartialPath> databases) {
        ArrayList<PartialPath> unExistDatabases = new ArrayList<PartialPath>();
        if (databases == null) {
            return unExistDatabases;
        }
        for (PartialPath database : databases) {
            if (this.isDatabaseExist(database.getFullPath())) continue;
            unExistDatabases.add(database);
        }
        return unExistDatabases;
    }

    public int getAssignedSeriesPartitionSlotsCount(String database) {
        return this.partitionInfo.getAssignedSeriesPartitionSlotsCount(database);
    }

    public List<Pair<Long, TConsensusGroupId>> getSortedRegionGroupSlotsCounter(String storageGroup, TConsensusGroupType type) throws NoAvailableRegionGroupException {
        List<Pair<Long, TConsensusGroupId>> regionGroupSlotsCounter = this.partitionInfo.getRegionGroupSlotsCounter(storageGroup, type);
        ArrayList<Pair<Long, TConsensusGroupId>> result = new ArrayList<Pair<Long, TConsensusGroupId>>();
        for (Pair<Long, TConsensusGroupId> slotsCounter : regionGroupSlotsCounter) {
            RegionGroupStatus status = this.getRegionGroupStatus((TConsensusGroupId)slotsCounter.getRight());
            if (RegionGroupStatus.Disabled.equals((Object)status)) continue;
            result.add(slotsCounter);
        }
        if (result.isEmpty()) {
            throw new NoAvailableRegionGroupException(type);
        }
        result.sort((o1, o2) -> {
            if ((Long)o1.getLeft() < (Long)o2.getLeft()) {
                return -1;
            }
            if ((Long)o1.getLeft() > (Long)o2.getLeft()) {
                return 1;
            }
            return this.getRegionGroupStatus((TConsensusGroupId)o1.getRight()).compareTo(this.getRegionGroupStatus((TConsensusGroupId)o2.getRight()));
        });
        return result;
    }

    public Set<TConsensusGroupId> getAllSchemaPartition() {
        return this.partitionInfo.getAllSchemaPartition();
    }

    public int generateNextRegionGroupId() {
        return this.partitionInfo.generateNextRegionGroupId();
    }

    public SchemaNodeManagementResp getNodePathsPartition(GetNodePathsPartitionPlan physicalPlan) {
        ConsensusReadResponse consensusReadResponse = this.getConsensusManager().read(physicalPlan);
        SchemaNodeManagementResp schemaNodeManagementResp = (SchemaNodeManagementResp)consensusReadResponse.getDataset();
        return schemaNodeManagementResp;
    }

    public void preDeleteDatabase(String database, PreDeleteDatabasePlan.PreDeleteType preDeleteType) {
        PreDeleteDatabasePlan preDeleteDatabasePlan = new PreDeleteDatabasePlan(database, preDeleteType);
        this.getConsensusManager().write(preDeleteDatabasePlan);
    }

    public boolean isDatabasePreDeleted(String database) {
        return this.partitionInfo.isDatabasePreDeleted(database);
    }

    public TSeriesPartitionSlot getSeriesPartitionSlot(String devicePath) {
        return this.executor.getSeriesPartitionSlot(devicePath);
    }

    public RegionInfoListResp getRegionInfoList(GetRegionInfoListPlan req) {
        RegionInfoListResp regionInfoListResp = (RegionInfoListResp)this.getConsensusManager().read(req).getDataset();
        Map<TConsensusGroupId, Integer> allLeadership = this.getLoadManager().getLatestRegionLeaderMap();
        regionInfoListResp.getRegionInfoList().forEach(regionInfo -> {
            regionInfo.setStatus(this.getRegionStatus(regionInfo.getConsensusGroupId(), regionInfo.getDataNodeId()).getStatus());
            String regionType = regionInfo.getDataNodeId() == allLeadership.getOrDefault(regionInfo.getConsensusGroupId(), -1).intValue() ? RegionRoleType.Leader.toString() : RegionRoleType.Follower.toString();
            regionInfo.setRoleType(regionType);
        });
        return regionInfoListResp;
    }

    public TSStatus updateRegionLocation(UpdateRegionLocationPlan req) {
        if (this.regionGroupCacheMap.containsKey(req.getRegionId())) {
            this.regionGroupCacheMap.get(req.getRegionId()).removeCacheIfExists(req.getOldNode().getDataNodeId());
        }
        return this.getConsensusManager().write(req).getStatus();
    }

    public GetRegionIdResp getRegionId(TGetRegionIdReq req) {
        GetRegionIdPlan plan = new GetRegionIdPlan(req.getDatabase(), req.getType(), req.isSetSeriesSlotId() ? req.getSeriesSlotId() : this.executor.getSeriesPartitionSlot(req.getDeviceId()), (TTimePartitionSlot)(req.isSetTimeSlotId() ? req.getTimeSlotId() : (req.isSetTimeStamp() ? new TTimePartitionSlot(req.getTimeStamp() - req.getTimeStamp() % CONF.getTimePartitionInterval()) : null)));
        return (GetRegionIdResp)this.getConsensusManager().read(plan).getDataset();
    }

    public GetTimeSlotListResp getTimeSlotList(GetTimeSlotListPlan plan) {
        return (GetTimeSlotListResp)this.getConsensusManager().read(plan).getDataset();
    }

    public GetSeriesSlotListResp getSeriesSlotList(GetSeriesSlotListPlan plan) {
        return (GetSeriesSlotListResp)this.getConsensusManager().read(plan).getDataset();
    }

    public String getRegionStorageGroup(TConsensusGroupId regionId) {
        return this.partitionInfo.getRegionStorageGroup(regionId);
    }

    public void maintainRegionReplicas() {
        Optional.ofNullable(this.getConsensusManager()).ifPresent(consensusManager -> {
            if (this.getConsensusManager().isLeader()) {
                List<RegionMaintainTask> regionMaintainTaskList = this.partitionInfo.getRegionMaintainEntryList();
                if (regionMaintainTaskList.isEmpty()) {
                    return;
                }
                HashMap<TConsensusGroupId, Queue> regionMaintainTaskMap = new HashMap<TConsensusGroupId, Queue>();
                for (RegionMaintainTask regionMaintainTask : regionMaintainTaskList) {
                    regionMaintainTaskMap.computeIfAbsent(regionMaintainTask.getRegionId(), k -> new LinkedList()).add(regionMaintainTask);
                }
                while (!regionMaintainTaskMap.isEmpty()) {
                    ArrayList<RegionMaintainTask> selectedRegionMaintainTask = new ArrayList<RegionMaintainTask>();
                    Enum currentType = null;
                    for (Map.Entry entry : regionMaintainTaskMap.entrySet()) {
                        RegionMaintainTask regionMaintainTask = (RegionMaintainTask)((Queue)entry.getValue()).peek();
                        if (regionMaintainTask == null) continue;
                        if (currentType == null) {
                            currentType = regionMaintainTask.getType();
                            selectedRegionMaintainTask.add((RegionMaintainTask)((Queue)entry.getValue()).peek());
                            continue;
                        }
                        if (!currentType.equals((Object)regionMaintainTask.getType()) || !currentType.equals((Object)RegionMaintainType.DELETE) && !((TConsensusGroupId)entry.getKey()).getType().equals((Object)((RegionMaintainTask)selectedRegionMaintainTask.get(0)).getRegionId().getType())) continue;
                        selectedRegionMaintainTask.add((RegionMaintainTask)((Queue)entry.getValue()).peek());
                    }
                    if (selectedRegionMaintainTask.isEmpty()) break;
                    HashSet<TConsensusGroupId> successfulTask = new HashSet<TConsensusGroupId>();
                    block0 : switch (1.$SwitchMap$org$apache$iotdb$confignode$persistence$partition$maintainer$RegionMaintainType[currentType.ordinal()]) {
                        case 1: {
                            switch (((RegionMaintainTask)selectedRegionMaintainTask.get(0)).getRegionId().getType()) {
                                case SchemaRegion: {
                                    AsyncClientHandler createSchemaRegionHandler = new AsyncClientHandler(DataNodeRequestType.CREATE_SCHEMA_REGION);
                                    for (RegionMaintainTask regionMaintainTask : selectedRegionMaintainTask) {
                                        RegionCreateTask regionCreateTask = (RegionCreateTask)regionMaintainTask;
                                        LOGGER.info("Start to create Region: {} on DataNode: {}", (Object)regionCreateTask.getRegionReplicaSet().getRegionId(), (Object)regionCreateTask.getTargetDataNode());
                                        createSchemaRegionHandler.putRequest(regionCreateTask.getRegionId().getId(), new TCreateSchemaRegionReq(regionCreateTask.getRegionReplicaSet(), regionCreateTask.getStorageGroup()));
                                        createSchemaRegionHandler.putDataNodeLocation(regionCreateTask.getRegionId().getId(), regionCreateTask.getTargetDataNode());
                                    }
                                    AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(createSchemaRegionHandler);
                                    for (Map.Entry entry : createSchemaRegionHandler.getResponseMap().entrySet()) {
                                        if (((TSStatus)entry.getValue()).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                                        successfulTask.add(new TConsensusGroupId(TConsensusGroupType.SchemaRegion, entry.getKey().intValue()));
                                    }
                                    break block0;
                                }
                                case DataRegion: {
                                    AsyncClientHandler createDataRegionHandler = new AsyncClientHandler(DataNodeRequestType.CREATE_DATA_REGION);
                                    for (RegionMaintainTask regionMaintainTask : selectedRegionMaintainTask) {
                                        RegionCreateTask dataRegionCreateTask = (RegionCreateTask)regionMaintainTask;
                                        LOGGER.info("Start to create Region: {} on DataNode: {}", (Object)dataRegionCreateTask.getRegionReplicaSet().getRegionId(), (Object)dataRegionCreateTask.getTargetDataNode());
                                        createDataRegionHandler.putRequest(dataRegionCreateTask.getRegionId().getId(), new TCreateDataRegionReq(dataRegionCreateTask.getRegionReplicaSet(), dataRegionCreateTask.getStorageGroup()).setTtl(dataRegionCreateTask.getTTL()));
                                        createDataRegionHandler.putDataNodeLocation(dataRegionCreateTask.getRegionId().getId(), dataRegionCreateTask.getTargetDataNode());
                                    }
                                    AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(createDataRegionHandler);
                                    for (Map.Entry entry : createDataRegionHandler.getResponseMap().entrySet()) {
                                        if (((TSStatus)entry.getValue()).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                                        successfulTask.add(new TConsensusGroupId(TConsensusGroupType.DataRegion, ((Integer)entry.getKey()).intValue()));
                                    }
                                }
                            }
                            break;
                        }
                        case 2: {
                            AsyncClientHandler deleteRegionHandler = new AsyncClientHandler(DataNodeRequestType.DELETE_REGION);
                            HashMap<Integer, TConsensusGroupId> regionIdMap = new HashMap<Integer, TConsensusGroupId>();
                            for (RegionMaintainTask regionMaintainTask : selectedRegionMaintainTask) {
                                RegionDeleteTask regionDeleteTask = (RegionDeleteTask)regionMaintainTask;
                                LOGGER.info("Start to delete Region: {} on DataNode: {}", (Object)regionDeleteTask.getRegionId(), (Object)regionDeleteTask.getTargetDataNode());
                                deleteRegionHandler.putRequest(regionDeleteTask.getRegionId().getId(), regionDeleteTask.getRegionId());
                                deleteRegionHandler.putDataNodeLocation(regionDeleteTask.getRegionId().getId(), regionDeleteTask.getTargetDataNode());
                                regionIdMap.put(regionDeleteTask.getRegionId().getId(), regionDeleteTask.getRegionId());
                            }
                            long startTime = System.currentTimeMillis();
                            AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(deleteRegionHandler);
                            LOGGER.info("Deleting regions costs {}ms", (Object)(System.currentTimeMillis() - startTime));
                            for (Map.Entry entry : deleteRegionHandler.getResponseMap().entrySet()) {
                                if (((TSStatus)entry.getValue()).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                                successfulTask.add((TConsensusGroupId)regionIdMap.get(entry.getKey()));
                            }
                            break;
                        }
                    }
                    if (successfulTask.isEmpty()) break;
                    for (TConsensusGroupId regionId : successfulTask) {
                        regionMaintainTaskMap.compute(regionId, (k, v) -> {
                            if (v == null) {
                                throw new IllegalStateException();
                            }
                            v.poll();
                            if (v.isEmpty()) {
                                return null;
                            }
                            return v;
                        });
                    }
                    this.getConsensusManager().write(new PollSpecificRegionMaintainTaskPlan(successfulTask));
                    if (successfulTask.size() >= selectedRegionMaintainTask.size()) continue;
                    break;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRegionCleaner() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentRegionMaintainerFuture == null) {
                this.currentRegionMaintainerFuture = ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.regionMaintainer, this::maintainRegionReplicas, (long)0L, (long)10L, (TimeUnit)TimeUnit.SECONDS);
                LOGGER.info("RegionCleaner is started successfully.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRegionCleaner() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentRegionMaintainerFuture != null) {
                this.currentRegionMaintainerFuture.cancel(false);
                this.currentRegionMaintainerFuture = null;
                this.regionGroupCacheMap.clear();
                LOGGER.info("RegionCleaner is stopped successfully.");
            }
        }
    }

    public Map<TConsensusGroupId, RegionGroupCache> getRegionGroupCacheMap() {
        return this.regionGroupCacheMap;
    }

    public void removeRegionGroupCache(TConsensusGroupId consensusGroupId) {
        this.regionGroupCacheMap.remove(consensusGroupId);
    }

    public List<TRegionReplicaSet> filterRegionGroupThroughStatus(String storageGroup, RegionGroupStatus ... status) {
        return this.getAllReplicaSets(storageGroup).stream().filter(regionReplicaSet -> {
            TConsensusGroupId regionGroupId = regionReplicaSet.getRegionId();
            return this.regionGroupCacheMap.containsKey(regionGroupId) && Arrays.stream(status).anyMatch(s -> s.equals((Object)this.regionGroupCacheMap.get(regionGroupId).getStatistics().getRegionGroupStatus()));
        }).collect(Collectors.toList());
    }

    public int countRegionWithSpecifiedStatus(TConsensusGroupType type, RegionStatus ... status) {
        AtomicInteger result = new AtomicInteger(0);
        this.regionGroupCacheMap.forEach((regionGroupId, regionGroupCache) -> {
            if (type.equals((Object)regionGroupId.getType())) {
                regionGroupCache.getStatistics().getRegionStatisticsMap().values().forEach(regionStatistics -> {
                    if (Arrays.stream(status).anyMatch(s -> s.equals((Object)regionStatistics.getRegionStatus()))) {
                        result.getAndIncrement();
                    }
                });
            }
        });
        return result.get();
    }

    public RegionStatus getRegionStatus(TConsensusGroupId consensusGroupId, int dataNodeId) {
        return this.regionGroupCacheMap.containsKey(consensusGroupId) ? this.regionGroupCacheMap.get(consensusGroupId).getStatistics().getRegionStatus(dataNodeId) : RegionStatus.Unknown;
    }

    public RegionGroupStatus getRegionGroupStatus(TConsensusGroupId consensusGroupId) {
        return this.regionGroupCacheMap.containsKey(consensusGroupId) ? this.regionGroupCacheMap.get(consensusGroupId).getStatistics().getRegionGroupStatus() : RegionGroupStatus.Disabled;
    }

    public void initRegionGroupHeartbeatCache() {
        this.regionGroupCacheMap.clear();
        this.getAllReplicaSets().forEach(regionReplicaSet -> this.regionGroupCacheMap.put(regionReplicaSet.getRegionId(), new RegionGroupCache(regionReplicaSet.getRegionId())));
    }

    public ScheduledExecutorService getRegionMaintainer() {
        return this.regionMaintainer;
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }

    private ProcedureManager getProcedureManager() {
        return this.configManager.getProcedureManager();
    }
}

