/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.node.heartbeat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.node.heartbeat.NodeHeartbeatSample;
import org.apache.iotdb.mpp.rpc.thrift.THeartbeatResp;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class NodeStatistics {
    private long loadScore;
    private NodeStatus status;
    private String statusReason;

    public NodeStatistics() {
    }

    public NodeStatistics(long loadScore, NodeStatus status, String statusReason) {
        this.loadScore = loadScore;
        this.status = status;
        this.statusReason = statusReason;
    }

    public long getLoadScore() {
        return this.loadScore;
    }

    public NodeStatus getStatus() {
        return this.status;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((long)this.loadScore, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.status.getStatus(), (OutputStream)stream);
        if (this.statusReason != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            ReadWriteIOUtils.write((String)this.statusReason, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
    }

    public void deserialize(ByteBuffer buffer) {
        this.loadScore = buffer.getLong();
        this.status = NodeStatus.parse((String)ReadWriteIOUtils.readString((ByteBuffer)buffer));
        this.statusReason = ReadWriteIOUtils.readBool((ByteBuffer)buffer) ? ReadWriteIOUtils.readString((ByteBuffer)buffer) : null;
    }

    public void deserialize(InputStream inputStream) throws IOException {
        this.loadScore = ReadWriteIOUtils.readLong((InputStream)inputStream);
        this.status = NodeStatus.parse((String)ReadWriteIOUtils.readString((InputStream)inputStream));
        this.statusReason = ReadWriteIOUtils.readBool((InputStream)inputStream) ? ReadWriteIOUtils.readString((InputStream)inputStream) : null;
    }

    public static NodeStatistics generateDefaultNodeStatistics() {
        return new NodeStatistics(Long.MAX_VALUE, NodeStatus.Unknown, null);
    }

    public NodeStatistics deepCopy() {
        return new NodeStatistics(this.loadScore, this.status, this.statusReason);
    }

    public NodeHeartbeatSample convertToNodeHeartbeatSample() {
        long currentTime = System.currentTimeMillis();
        return new NodeHeartbeatSample(new THeartbeatResp(currentTime, this.status.getStatus()).setStatusReason(this.statusReason), currentTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeStatistics that = (NodeStatistics)o;
        return this.loadScore == that.loadScore && this.status == that.status && Objects.equals(this.statusReason, that.statusReason);
    }

    public int hashCode() {
        return Objects.hash(this.loadScore, this.status, this.statusReason);
    }

    public String toString() {
        return "NodeStatistics{loadScore=" + this.loadScore + ", status=" + this.status + ", statusReason='" + (this.statusReason == null ? "null" : this.statusReason) + '\'' + '}';
    }
}

