/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.node;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.rpc.TSStatusCode;

public class ClusterNodeStartUtils {
    private static final String CLUSTER_NAME = ConfigNodeDescriptor.getInstance().getConf().getClusterName();
    private static final String POSSIBLE_SOLUTIONS = " Possible solutions are as follows:\r\n";
    public static final TSStatus ACCEPT_NODE_REGISTRATION = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("Accept Node registration.");
    public static final TSStatus ACCEPT_NODE_RESTART = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("Accept Node restart.");

    public static TSStatus confirmNodeRegistration(NodeType nodeType, String clusterName, Object nodeLocation, ConfigManager configManager) {
        List<TEndPoint> conflictEndPoints;
        String CONF_FILE_NAME = NodeType.ConfigNode.equals((Object)nodeType) ? "iotdb-confignode.properties" : "iotdb-datanode.properties";
        TSStatus status = new TSStatus();
        if (!CLUSTER_NAME.equals(clusterName)) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s start. Because the ClusterName of the current %s and the target cluster are inconsistent. ClusterName of the current Node: %s, ClusterName of the target cluster: %s. Possible solutions are as follows:\r\n\t1. Change the target_config_node_list parameter in %s to join the correct cluster.\n\t2. Change the cluster_name parameter in %s to match the target cluster", nodeType.getNodeType(), nodeType.getNodeType(), clusterName, CLUSTER_NAME, CONF_FILE_NAME, CONF_FILE_NAME));
            return status;
        }
        switch (nodeType) {
            case ConfigNode: {
                conflictEndPoints = ClusterNodeStartUtils.checkConflictTEndPointForNewConfigNode((TConfigNodeLocation)nodeLocation, configManager.getNodeManager().getRegisteredConfigNodes());
                break;
            }
            default: {
                conflictEndPoints = ClusterNodeStartUtils.checkConflictTEndPointForNewDataNode((TDataNodeLocation)nodeLocation, configManager.getNodeManager().getRegisteredDataNodes());
            }
        }
        if (!conflictEndPoints.isEmpty()) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s registration. Because the following ip:port: %s of the current %s is conflicted with other registered Nodes in the cluster. Possible solutions are as follows:\r\n\t1. Use SQL: \"show cluster details\" to find out the conflict Nodes. Remove them and retry start.\n\t2. Change the conflict ip:port configurations in %s file and retry start.", nodeType.getNodeType(), conflictEndPoints, nodeType.getNodeType(), CONF_FILE_NAME));
            return status;
        }
        return ACCEPT_NODE_REGISTRATION;
    }

    public static TSStatus confirmNodeRestart(NodeType nodeType, String clusterName, int nodeId, Object nodeLocation, ConfigManager configManager) {
        TConfigNodeLocation matchedNodeLocation;
        String CONF_FILE_NAME = NodeType.ConfigNode.equals((Object)nodeType) ? "iotdb-confignode.properties" : "iotdb-datanode.properties";
        TSStatus status = new TSStatus();
        if (!CLUSTER_NAME.equals(clusterName)) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s restart. Because the ClusterName of the current %s and the target cluster are inconsistent. ClusterName of the current Node: %s, ClusterName of the target cluster: %s. Possible solutions are as follows:\r\n\t1. Change the target_config_node_list parameter in %s to join the correct cluster.\n\t2. Change the cluster_name parameter in %s to match the target cluster", nodeType.getNodeType(), nodeType.getNodeType(), clusterName, CLUSTER_NAME, CONF_FILE_NAME, CONF_FILE_NAME));
            return status;
        }
        if (nodeId < 0) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s restart. Because the nodeId of the current %s is %d. Possible solutions are as follows:\r\n\t1. Delete \"data\" dir and retry.", nodeType.getNodeType(), nodeType.getNodeType(), nodeId));
            return status;
        }
        switch (nodeType) {
            case ConfigNode: {
                matchedNodeLocation = ClusterNodeStartUtils.matchRegisteredConfigNode((TConfigNodeLocation)nodeLocation, configManager.getNodeManager().getRegisteredConfigNodes());
                break;
            }
            default: {
                matchedNodeLocation = ClusterNodeStartUtils.matchRegisteredDataNode((TDataNodeLocation)nodeLocation, configManager.getNodeManager().getRegisteredDataNodes());
            }
        }
        if (matchedNodeLocation == null) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s restart. Because there are no corresponding %s(whose nodeId=%d) in the cluster. Possible solutions are as follows:\r\n\t1. Maybe you've already removed the current %s(whose nodeId=%d). Please delete the useless 'data' dir and retry start.", nodeType.getNodeType(), nodeType.getNodeType(), nodeId, nodeType.getNodeType(), nodeId));
            return status;
        }
        boolean acceptRestart = true;
        switch (nodeType) {
            case ConfigNode: {
                Set<Integer> updatedTEndPoints = ClusterNodeStartUtils.checkUpdatedTEndPointOfConfigNode((TConfigNodeLocation)nodeLocation, matchedNodeLocation);
                if (updatedTEndPoints.isEmpty()) break;
                acceptRestart = false;
                break;
            }
            default: {
                Set<Integer> updatedTEndPoints = ClusterNodeStartUtils.checkUpdatedTEndPointOfDataNode((TDataNodeLocation)nodeLocation, (TDataNodeLocation)matchedNodeLocation);
                if (updatedTEndPoints.stream().max(Integer::compare).orElse(-1) <= 0) break;
                acceptRestart = false;
            }
        }
        if (!acceptRestart) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s restart. Because the internal TEndPoints of this %s can't be modified. Possible solutions are as follows:\r\n\t1. Please keep the internal TEndPoints of this Node the same as before.", nodeType.getNodeType(), nodeType.getNodeType()));
            return status;
        }
        return ACCEPT_NODE_RESTART;
    }

    public static List<TEndPoint> checkConflictTEndPointForNewConfigNode(TConfigNodeLocation newConfigNodeLocation, List<TConfigNodeLocation> registeredConfigNodes) {
        HashSet<TEndPoint> conflictEndPointSet = new HashSet<TEndPoint>();
        for (TConfigNodeLocation registeredConfigNode : registeredConfigNodes) {
            if (registeredConfigNode.getInternalEndPoint().equals(newConfigNodeLocation.getInternalEndPoint())) {
                conflictEndPointSet.add(newConfigNodeLocation.getInternalEndPoint());
            }
            if (!registeredConfigNode.getConsensusEndPoint().equals(newConfigNodeLocation.getConsensusEndPoint())) continue;
            conflictEndPointSet.add(newConfigNodeLocation.getConsensusEndPoint());
        }
        return new ArrayList<TEndPoint>(conflictEndPointSet);
    }

    public static List<TEndPoint> checkConflictTEndPointForNewDataNode(TDataNodeLocation newDataNodeLocation, List<TDataNodeConfiguration> registeredDataNodes) {
        HashSet<TEndPoint> conflictEndPointSet = new HashSet<TEndPoint>();
        for (TDataNodeConfiguration registeredDataNode : registeredDataNodes) {
            TDataNodeLocation registeredLocation = registeredDataNode.getLocation();
            if (registeredLocation.getClientRpcEndPoint().equals(newDataNodeLocation.getClientRpcEndPoint())) {
                conflictEndPointSet.add(newDataNodeLocation.getClientRpcEndPoint());
            }
            if (registeredLocation.getInternalEndPoint().equals(newDataNodeLocation.getInternalEndPoint())) {
                conflictEndPointSet.add(newDataNodeLocation.getInternalEndPoint());
            }
            if (registeredLocation.getMPPDataExchangeEndPoint().equals(newDataNodeLocation.getMPPDataExchangeEndPoint())) {
                conflictEndPointSet.add(newDataNodeLocation.getMPPDataExchangeEndPoint());
            }
            if (registeredLocation.getSchemaRegionConsensusEndPoint().equals(newDataNodeLocation.getSchemaRegionConsensusEndPoint())) {
                conflictEndPointSet.add(newDataNodeLocation.getSchemaRegionConsensusEndPoint());
            }
            if (!registeredLocation.getDataRegionConsensusEndPoint().equals(newDataNodeLocation.getDataRegionConsensusEndPoint())) continue;
            conflictEndPointSet.add(newDataNodeLocation.getDataRegionConsensusEndPoint());
        }
        return new ArrayList<TEndPoint>(conflictEndPointSet);
    }

    public static TConfigNodeLocation matchRegisteredConfigNode(TConfigNodeLocation configNodeLocation, List<TConfigNodeLocation> registeredConfigNodes) {
        for (TConfigNodeLocation registeredConfigNode : registeredConfigNodes) {
            if (registeredConfigNode.getConfigNodeId() != configNodeLocation.getConfigNodeId()) continue;
            return registeredConfigNode;
        }
        return null;
    }

    public static TDataNodeLocation matchRegisteredDataNode(TDataNodeLocation dataNodeLocation, List<TDataNodeConfiguration> registeredDataNodes) {
        for (TDataNodeConfiguration registeredDataNode : registeredDataNodes) {
            if (registeredDataNode.getLocation().getDataNodeId() != dataNodeLocation.getDataNodeId()) continue;
            return registeredDataNode.getLocation();
        }
        return null;
    }

    public static Set<Integer> checkUpdatedTEndPointOfConfigNode(TConfigNodeLocation restartLocation, TConfigNodeLocation recordLocation) {
        HashSet<Integer> updatedTEndPoints = new HashSet<Integer>();
        if (!recordLocation.getInternalEndPoint().equals(restartLocation.getInternalEndPoint())) {
            updatedTEndPoints.add(0);
        }
        if (!recordLocation.getConsensusEndPoint().equals(restartLocation.getConsensusEndPoint())) {
            updatedTEndPoints.add(1);
        }
        return updatedTEndPoints;
    }

    public static Set<Integer> checkUpdatedTEndPointOfDataNode(TDataNodeLocation restartLocation, TDataNodeLocation recordLocation) {
        HashSet<Integer> updatedTEndPoints = new HashSet<Integer>();
        if (!recordLocation.getClientRpcEndPoint().equals(restartLocation.getClientRpcEndPoint())) {
            updatedTEndPoints.add(0);
        }
        if (!recordLocation.getInternalEndPoint().equals(restartLocation.getInternalEndPoint())) {
            updatedTEndPoints.add(1);
        }
        if (!recordLocation.getMPPDataExchangeEndPoint().equals(restartLocation.getMPPDataExchangeEndPoint())) {
            updatedTEndPoints.add(2);
        }
        if (!recordLocation.getSchemaRegionConsensusEndPoint().equals(restartLocation.getSchemaRegionConsensusEndPoint())) {
            updatedTEndPoints.add(3);
        }
        if (!recordLocation.getDataRegionConsensusEndPoint().equals(restartLocation.getDataRegionConsensusEndPoint())) {
            updatedTEndPoints.add(4);
        }
        return updatedTEndPoints;
    }
}

