/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.node.heartbeat.BaseNodeCache;
import org.apache.iotdb.mpp.rpc.thrift.TOperatePipeOnDataNodeReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryFailedTasksThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryFailedTasksThread.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final long HEARTBEAT_INTERVAL = CONF.getHeartbeatIntervalInMs();
    private final IManager configManager;
    private final NodeManager nodeManager;
    private final ScheduledExecutorService retryFailTasksExecutor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"Cluster-RetryFailedTasks-Service");
    private final Object scheduleMonitor = new Object();
    private Future<?> currentFailedTasksRetryThreadFuture;
    private final Set<TDataNodeLocation> oldUnknownNodes;
    private final Map<Integer, Queue<TOperatePipeOnDataNodeReq>> messageMap = new ConcurrentHashMap<Integer, Queue<TOperatePipeOnDataNodeReq>>();

    public RetryFailedTasksThread(IManager configManager) {
        this.configManager = configManager;
        this.nodeManager = configManager.getNodeManager();
        this.oldUnknownNodes = new HashSet<TDataNodeLocation>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRetryFailedTasksService() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentFailedTasksRetryThreadFuture == null) {
                this.currentFailedTasksRetryThreadFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.retryFailTasksExecutor, this::retryFailedTasks, (long)0L, (long)HEARTBEAT_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
                LOGGER.info("RetryFailMissions service is started successfully.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRetryFailedTasksService() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentFailedTasksRetryThreadFuture != null) {
                this.currentFailedTasksRetryThreadFuture.cancel(false);
                this.currentFailedTasksRetryThreadFuture = null;
                LOGGER.info("RetryFailMissions service is stopped successfully.");
            }
        }
    }

    private void retryFailedTasks() {
        this.triggerDetectTask();
        this.syncDetectTask();
    }

    private void triggerDetectTask() {
        TSStatus transferResult;
        ArrayList<TDataNodeLocation> newUnknownNodes = new ArrayList<TDataNodeLocation>();
        this.nodeManager.getRegisteredDataNodes().forEach(DataNodeConfiguration -> {
            TDataNodeLocation dataNodeLocation = DataNodeConfiguration.getLocation();
            BaseNodeCache newestNodeInformation = this.nodeManager.getNodeCacheMap().get(dataNodeLocation.dataNodeId);
            if (newestNodeInformation != null) {
                if (newestNodeInformation.getNodeStatus() == NodeStatus.Running) {
                    this.oldUnknownNodes.remove(dataNodeLocation);
                } else if (!this.oldUnknownNodes.contains(dataNodeLocation) && newestNodeInformation.getNodeStatus() == NodeStatus.Unknown) {
                    newUnknownNodes.add(dataNodeLocation);
                }
            }
        });
        if (!newUnknownNodes.isEmpty() && (transferResult = this.configManager.transfer(newUnknownNodes)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.oldUnknownNodes.addAll(newUnknownNodes);
        }
    }

    public void retryRollbackReq(List<Integer> dataNodeIds, TOperatePipeOnDataNodeReq req) {
        for (int id : dataNodeIds) {
            this.messageMap.computeIfAbsent(id, i -> new LinkedList()).add(req);
        }
    }

    private void syncDetectTask() {
        block0: for (Map.Entry<Integer, Queue<TOperatePipeOnDataNodeReq>> entry : this.messageMap.entrySet()) {
            TOperatePipeOnDataNodeReq request;
            int dataNodeId = entry.getKey();
            if (!NodeStatus.Running.equals((Object)this.nodeManager.getNodeStatusByNodeId(dataNodeId))) continue;
            HashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new HashMap<Integer, TDataNodeLocation>();
            dataNodeLocationMap.put(dataNodeId, this.nodeManager.getRegisteredDataNodeLocations().get(dataNodeId));
            while ((request = entry.getValue().peek()) != null) {
                AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.ROLLBACK_OPERATE_PIPE, request, dataNodeLocationMap);
                AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
                TSStatus tsStatus = (TSStatus)clientHandler.getResponseList().get(0);
                if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    entry.getValue().poll();
                    continue;
                }
                if (tsStatus.getCode() == TSStatusCode.PIPE_ERROR.getStatusCode()) {
                    LOGGER.warn(String.format("Roll back failed because %s. Skip this roll back request [%s].", tsStatus.getMessage(), request));
                    continue;
                }
                LOGGER.error(String.format("Roll back failed because %s. This roll back request [%s] will be retried later.", tsStatus.getMessage(), request));
                continue block0;
            }
        }
    }
}

