/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.jvm;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.metricsets.jvm.JvmUtils;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class JvmMemoryMetrics
implements IMetricSet {
    @Override
    public void bindTo(AbstractMetricService metricService) {
        for (BufferPoolMXBean bufferPoolBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            metricService.createAutoGauge("jvm_buffer_count_buffers", MetricLevel.CORE, bufferPoolBean, BufferPoolMXBean::getCount, "id", bufferPoolBean.getName());
            metricService.createAutoGauge("jvm_buffer_memory_used_bytes", MetricLevel.CORE, bufferPoolBean, BufferPoolMXBean::getMemoryUsed, "id", bufferPoolBean.getName());
            metricService.createAutoGauge("jvm_buffer_total_capacity_bytes", MetricLevel.CORE, bufferPoolBean, BufferPoolMXBean::getTotalCapacity, "id", bufferPoolBean.getName());
        }
        for (MemoryPoolMXBean memoryPoolBean : ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class)) {
            String area = MemoryType.HEAP.equals((Object)memoryPoolBean.getType()) ? "heap" : "nonheap";
            metricService.createAutoGauge("jvm_memory_used_bytes", MetricLevel.CORE, memoryPoolBean, mem -> JvmUtils.getUsageValue(mem, MemoryUsage::getUsed), "id", memoryPoolBean.getName(), "area", area);
            metricService.createAutoGauge("jvm_memory_committed_bytes", MetricLevel.CORE, memoryPoolBean, mem -> JvmUtils.getUsageValue(mem, MemoryUsage::getCommitted), "id", memoryPoolBean.getName(), "area", area);
            metricService.createAutoGauge("jvm_memory_max_bytes", MetricLevel.CORE, memoryPoolBean, mem -> JvmUtils.getUsageValue(mem, MemoryUsage::getMax), "id", memoryPoolBean.getName(), "area", area);
        }
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        for (BufferPoolMXBean bufferPoolBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            metricService.remove(MetricType.AUTO_GAUGE, "jvm_buffer_count_buffers", "id", bufferPoolBean.getName());
            metricService.remove(MetricType.AUTO_GAUGE, "jvm_buffer_memory_used_bytes", "id", bufferPoolBean.getName());
            metricService.remove(MetricType.AUTO_GAUGE, "jvm_buffer_total_capacity_bytes", "id", bufferPoolBean.getName());
        }
        for (MemoryPoolMXBean memoryPoolBean : ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class)) {
            String area = MemoryType.HEAP.equals((Object)memoryPoolBean.getType()) ? "heap" : "nonheap";
            metricService.remove(MetricType.AUTO_GAUGE, "jvm_memory_used_bytes", "id", memoryPoolBean.getName(), "area", area);
            metricService.remove(MetricType.AUTO_GAUGE, "jvm_memory_committed_bytes", "id", memoryPoolBean.getName(), "area", area);
            metricService.remove(MetricType.AUTO_GAUGE, "jvm_memory_max_bytes", "id", memoryPoolBean.getName(), "area", area);
        }
    }
}

