/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.model;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.iotdb.commons.model.ModelHyperparameter;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TrailInformation {
    public static final String MODEL_PATH = "model_path";
    private final String trailId;
    private final ModelHyperparameter modelHyperparameter;
    private String modelPath;

    public TrailInformation(String trailId, ModelHyperparameter modelHyperparameter, String modelPath) {
        this.trailId = trailId;
        this.modelHyperparameter = modelHyperparameter;
        this.modelPath = modelPath;
    }

    public void update(Map<String, String> modelInfo) {
        if (modelInfo.containsKey(MODEL_PATH)) {
            this.modelPath = modelInfo.get(MODEL_PATH);
            modelInfo.remove(MODEL_PATH);
        }
        this.modelHyperparameter.update(modelInfo);
    }

    public String getTrailId() {
        return this.trailId;
    }

    public ModelHyperparameter getModelHyperparameter() {
        return this.modelHyperparameter;
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public ByteBuffer serializeShowTrailResult() throws IOException {
        PublicBAOS buffer = new PublicBAOS();
        DataOutputStream stream = new DataOutputStream((OutputStream)buffer);
        ReadWriteIOUtils.write((String)this.trailId, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.modelHyperparameter.toString(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.modelPath, (OutputStream)stream);
        return ByteBuffer.wrap(buffer.getBuf(), 0, buffer.size());
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.trailId, (OutputStream)stream);
        this.modelHyperparameter.serialize(stream);
        ReadWriteIOUtils.write((String)this.modelPath, (OutputStream)stream);
    }

    public void serialize(FileOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.trailId, (OutputStream)stream);
        this.modelHyperparameter.serialize(stream);
        ReadWriteIOUtils.write((String)this.modelPath, (OutputStream)stream);
    }

    public static TrailInformation deserialize(ByteBuffer buffer) {
        return new TrailInformation(ReadWriteIOUtils.readString((ByteBuffer)buffer), ModelHyperparameter.deserialize(buffer), ReadWriteIOUtils.readString((ByteBuffer)buffer));
    }

    public static TrailInformation deserialize(InputStream stream) throws IOException {
        return new TrailInformation(ReadWriteIOUtils.readString((InputStream)stream), ModelHyperparameter.deserialize(stream), ReadWriteIOUtils.readString((InputStream)stream));
    }
}

