/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze.schema;

import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.common.schematree.ISchemaTree;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.BatchInsertNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class SchemaValidator {
    private static final ISchemaFetcher SCHEMA_FETCHER = ClusterSchemaFetcher.getInstance();

    public static void validate(InsertNode insertNode) {
        try {
            if (insertNode instanceof BatchInsertNode) {
                SCHEMA_FETCHER.fetchAndComputeSchemaWithAutoCreate(((BatchInsertNode)((Object)insertNode)).getSchemaValidationList());
            } else {
                SCHEMA_FETCHER.fetchAndComputeSchemaWithAutoCreate(insertNode.getSchemaValidation());
            }
            insertNode.updateAfterSchemaValidation();
        }
        catch (QueryProcessException e) {
            throw new SemanticException((Throwable)((Object)e));
        }
    }

    public static ISchemaTree validate(List<PartialPath> devicePaths, List<String[]> measurements, List<TSDataType[]> dataTypes, List<TSEncoding[]> encodings, List<CompressionType[]> compressionTypes, List<Boolean> isAlignedList) {
        return SCHEMA_FETCHER.fetchSchemaListWithAutoCreate(devicePaths, measurements, dataTypes, encodings, compressionTypes, isAlignedList);
    }
}

