/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.metric.QueryMetricsManager;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.analyze.AnalyzeVisitor;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.statement.Statement;

public class Analyzer {
    private final MPPQueryContext context;
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;

    public Analyzer(MPPQueryContext context, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        this.context = context;
        this.partitionFetcher = partitionFetcher;
        this.schemaFetcher = schemaFetcher;
    }

    public Analysis analyze(Statement statement) {
        long startTime = System.nanoTime();
        Analysis analysis = (Analysis)new AnalyzeVisitor(this.partitionFetcher, this.schemaFetcher).process(statement, this.context);
        if (statement.isQuery()) {
            QueryMetricsManager.getInstance().recordPlanCost("analyzer", System.nanoTime() - startTime);
        }
        return analysis;
    }

    public static void validate(Statement statement) {
        MPPQueryContext context = new MPPQueryContext(QueryId.mockQueryId);
        ClusterPartitionFetcher partitionFetcher = ClusterPartitionFetcher.getInstance();
        ClusterSchemaFetcher schemaFetcher = ClusterSchemaFetcher.getInstance();
        Analyzer analyzer = new Analyzer(context, partitionFetcher, schemaFetcher);
        analyzer.analyze(statement);
    }
}

