/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.schedule;

import com.google.common.base.Ticker;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.execution.driver.IDriver;
import org.apache.iotdb.db.mpp.execution.schedule.AbstractDriverThread;
import org.apache.iotdb.db.mpp.execution.schedule.ExecutionContext;
import org.apache.iotdb.db.mpp.execution.schedule.ITaskScheduler;
import org.apache.iotdb.db.mpp.execution.schedule.ThreadProducer;
import org.apache.iotdb.db.mpp.execution.schedule.queue.IndexedBlockingQueue;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTask;
import org.apache.iotdb.db.utils.SetThreadName;

public class DriverTaskThread
extends AbstractDriverThread {
    public static final Duration EXECUTION_TIME_SLICE = new Duration((double)IoTDBDescriptor.getInstance().getConfig().getDriverTaskExecutionTimeSliceInMs(), TimeUnit.MILLISECONDS);
    private static final Executor listeningExecutor = IoTDBThreadPoolFactory.newCachedThreadPool((String)"scheduler-notification");
    private final Ticker ticker = Ticker.systemTicker();

    public DriverTaskThread(String workerId, ThreadGroup tg, IndexedBlockingQueue<DriverTask> queue, ITaskScheduler scheduler, ThreadProducer producer) {
        super(workerId, tg, queue, scheduler, producer);
    }

    @Override
    public void execute(DriverTask task) throws InterruptedException {
        long startNanos = this.ticker.read();
        if (!this.scheduler.readyToRunning(task)) {
            return;
        }
        IDriver driver = task.getDriver();
        ListenableFuture<?> future = driver.processFor(EXECUTION_TIME_SLICE);
        if (future.isCancelled()) {
            task.setAbortCause("already being cancelled");
            this.scheduler.toAborted(task);
            return;
        }
        long quantaScheduledNanos = this.ticker.read() - startNanos;
        ExecutionContext context = new ExecutionContext();
        context.setScheduledTimeInNanos(quantaScheduledNanos);
        context.setTimeSlice(EXECUTION_TIME_SLICE);
        if (driver.isFinished()) {
            this.scheduler.runningToFinished(task, context);
            return;
        }
        if (future.isDone()) {
            this.scheduler.runningToReady(task, context);
        } else {
            this.scheduler.runningToBlocked(task, context);
            future.addListener(() -> {
                try (SetThreadName driverTaskName2 = new SetThreadName(task.getDriver().getDriverTaskId().getFullId());){
                    this.scheduler.blockedToReady(task);
                }
            }, listeningExecutor);
        }
    }
}

