/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.window;

import org.apache.iotdb.db.mpp.execution.operator.window.AbstractVariationWindow;
import org.apache.iotdb.db.mpp.execution.operator.window.VariationWindowParameter;
import org.apache.iotdb.tsfile.read.common.block.column.Column;

public abstract class AbstractVariationIntWindow
extends AbstractVariationWindow {
    protected int headValue;
    private int previousValue;

    public AbstractVariationIntWindow(VariationWindowParameter variationWindowParameter) {
        super(variationWindowParameter);
    }

    @Override
    public void updatePreviousValue() {
        this.previousValue = this.headValue;
    }

    @Override
    public void mergeOnePoint(Column[] controlTimeAndValueColumn, int index) {
        long currentTime = controlTimeAndValueColumn[1].getLong(index);
        if (this.startTime > currentTime) {
            this.startTime = currentTime;
        }
        if (this.endTime < currentTime) {
            this.endTime = currentTime;
        }
        if (!this.initializedHeadValue) {
            this.startTime = currentTime;
            this.endTime = currentTime;
            if (controlTimeAndValueColumn[0].isNull(index)) {
                this.valueIsNull = true;
            } else {
                this.valueIsNull = false;
                this.headValue = controlTimeAndValueColumn[0].getInt(index);
            }
            this.initializedHeadValue = true;
        }
    }

    public int getHeadValue() {
        return this.headValue;
    }

    public int getPreviousHeadValue() {
        return this.previousValue;
    }
}

