/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.source;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.ToLongFunction;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.metric.QueryMetricsManager;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.chunk.MemAlignedPageReader;
import org.apache.iotdb.db.query.reader.chunk.MemPageReader;
import org.apache.iotdb.db.query.reader.universal.DescPriorityMergeReader;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReader;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IAlignedPageReader;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.read.reader.series.PaginationController;

public class SeriesScanUtil {
    private final QueryContext context;
    private final PartialPath seriesPath;
    protected boolean isAligned = false;
    protected final TSDataType dataType;
    private final TimeOrderUtils orderUtils;
    private QueryDataSource dataSource;
    protected int curSeqFileIndex;
    protected int curUnseqFileIndex;
    protected ITimeSeriesMetadata firstTimeSeriesMetadata;
    protected final List<ITimeSeriesMetadata> seqTimeSeriesMetadata;
    protected final PriorityQueue<ITimeSeriesMetadata> unSeqTimeSeriesMetadata;
    protected IChunkMetadata firstChunkMetadata;
    protected final PriorityQueue<IChunkMetadata> cachedChunkMetadata;
    protected VersionPageReader firstPageReader;
    protected final List<VersionPageReader> seqPageReaders;
    protected final PriorityQueue<VersionPageReader> unSeqPageReaders;
    protected final PriorityMergeReader mergeReader;
    protected boolean hasCachedNextOverlappedPage;
    protected TsBlock cachedTsBlock;
    protected SeriesScanOptions scanOptions;
    protected PaginationController paginationController;
    private static final QueryMetricsManager QUERY_METRICS = QueryMetricsManager.getInstance();

    public SeriesScanUtil(PartialPath seriesPath, Ordering scanOrder, SeriesScanOptions scanOptions, FragmentInstanceContext context) {
        this.seriesPath = IDTable.translateQueryPath(seriesPath);
        this.dataType = seriesPath.getSeriesType();
        this.scanOptions = scanOptions;
        this.paginationController = scanOptions.getPaginationController();
        this.context = context;
        if (scanOrder.isAscending()) {
            this.orderUtils = new AscTimeOrderUtils();
            this.mergeReader = this.getPriorityMergeReader();
        } else {
            this.orderUtils = new DescTimeOrderUtils();
            this.mergeReader = this.getDescPriorityMergeReader();
        }
        this.seqTimeSeriesMetadata = new LinkedList<ITimeSeriesMetadata>();
        this.unSeqTimeSeriesMetadata = new PriorityQueue<ITimeSeriesMetadata>(this.orderUtils.comparingLong(timeSeriesMetadata -> this.orderUtils.getOrderTime((Statistics<? extends Object>)timeSeriesMetadata.getStatistics())));
        this.cachedChunkMetadata = new PriorityQueue<IChunkMetadata>(this.orderUtils.comparingLong(chunkMetadata -> this.orderUtils.getOrderTime((Statistics<? extends Object>)chunkMetadata.getStatistics())));
        this.seqPageReaders = new LinkedList<VersionPageReader>();
        this.unSeqPageReaders = new PriorityQueue<VersionPageReader>(this.orderUtils.comparingLong(versionPageReader -> this.orderUtils.getOrderTime((Statistics<? extends Object>)versionPageReader.getStatistics())));
    }

    public void initQueryDataSource(QueryDataSource dataSource) {
        dataSource.fillOrderIndexes(this.seriesPath.getDevice(), this.orderUtils.getAscending());
        this.dataSource = dataSource;
        this.scanOptions.setTTL(dataSource.getDataTTL());
        this.orderUtils.setCurSeqFileIndex(dataSource);
        this.curUnseqFileIndex = 0;
    }

    protected PriorityMergeReader getPriorityMergeReader() {
        return new PriorityMergeReader();
    }

    protected DescPriorityMergeReader getDescPriorityMergeReader() {
        return new DescPriorityMergeReader();
    }

    public boolean hasNextFile() throws IOException {
        if (!this.paginationController.hasCurLimit()) {
            return false;
        }
        if (!this.unSeqPageReaders.isEmpty() || this.firstPageReader != null || this.mergeReader.hasNextTimeValuePair()) {
            throw new IOException("all cached pages should be consumed first unSeqPageReaders.isEmpty() is " + this.unSeqPageReaders.isEmpty() + " firstPageReader != null is " + (this.firstPageReader != null) + " mergeReader.hasNextTimeValuePair() = " + this.mergeReader.hasNextTimeValuePair());
        }
        if (this.firstChunkMetadata != null || !this.cachedChunkMetadata.isEmpty()) {
            throw new IOException("all cached chunks should be consumed first");
        }
        if (this.firstTimeSeriesMetadata != null) {
            return true;
        }
        while (this.firstTimeSeriesMetadata == null && (this.orderUtils.hasNextSeqResource() || this.orderUtils.hasNextUnseqResource() || !this.seqTimeSeriesMetadata.isEmpty() || !this.unSeqTimeSeriesMetadata.isEmpty())) {
            this.tryToUnpackAllOverlappedFilesToTimeSeriesMetadata();
            this.filterFirstTimeSeriesMetadata();
        }
        return this.firstTimeSeriesMetadata != null;
    }

    boolean isFileOverlapped() throws IOException {
        if (this.firstTimeSeriesMetadata == null) {
            throw new IOException("no first file");
        }
        Statistics fileStatistics = this.firstTimeSeriesMetadata.getStatistics();
        return !this.seqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)fileStatistics, (Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics()) || !this.unSeqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)fileStatistics, (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics());
    }

    Statistics currentFileStatistics() {
        return this.firstTimeSeriesMetadata.getStatistics();
    }

    protected Statistics currentFileStatistics(int index) throws IOException {
        Preconditions.checkArgument((index == 0 ? 1 : 0) != 0, (Object)"Only one sensor in non-aligned SeriesScanUtil.");
        return this.currentFileStatistics();
    }

    protected Statistics currentFileTimeStatistics() throws IOException {
        return this.currentFileStatistics();
    }

    boolean currentFileModified() throws IOException {
        if (this.firstTimeSeriesMetadata == null) {
            throw new IOException("no first file");
        }
        return this.firstTimeSeriesMetadata.isModified();
    }

    void skipCurrentFile() {
        this.firstTimeSeriesMetadata = null;
    }

    public boolean hasNextChunk() throws IOException {
        if (!this.paginationController.hasCurLimit()) {
            return false;
        }
        if (!this.unSeqPageReaders.isEmpty() || this.firstPageReader != null || this.mergeReader.hasNextTimeValuePair()) {
            throw new IOException("all cached pages should be consumed first unSeqPageReaders.isEmpty() is " + this.unSeqPageReaders.isEmpty() + " firstPageReader != null is " + (this.firstPageReader != null) + " mergeReader.hasNextTimeValuePair() = " + this.mergeReader.hasNextTimeValuePair());
        }
        if (this.firstChunkMetadata != null) {
            return true;
        }
        if (this.firstTimeSeriesMetadata == null && this.cachedChunkMetadata.isEmpty()) {
            return false;
        }
        while (this.firstChunkMetadata == null && (!this.cachedChunkMetadata.isEmpty() || this.hasNextFile())) {
            this.initFirstChunkMetadata();
            this.filterFirstChunkMetadata();
        }
        return this.firstChunkMetadata != null;
    }

    protected void filterFirstChunkMetadata() throws IOException {
        if (this.firstChunkMetadata != null && !this.isChunkOverlapped() && !this.firstChunkMetadata.isModified()) {
            Filter queryFilter = this.scanOptions.getQueryFilter();
            Statistics statistics = this.firstChunkMetadata.getStatistics();
            if (queryFilter == null || queryFilter.allSatisfy(statistics)) {
                long rowCount = statistics.getCount();
                if (this.paginationController.hasCurOffset(rowCount)) {
                    this.skipCurrentChunk();
                    this.paginationController.consumeOffset(rowCount);
                }
            } else if (!queryFilter.satisfy(statistics)) {
                this.skipCurrentChunk();
            }
        }
    }

    private void initFirstChunkMetadata() throws IOException {
        if (this.firstTimeSeriesMetadata != null) {
            this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstTimeSeriesMetadata.getStatistics()));
            this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstTimeSeriesMetadata.getStatistics()), true);
        } else {
            while (!this.cachedChunkMetadata.isEmpty()) {
                this.firstChunkMetadata = this.cachedChunkMetadata.peek();
                this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstChunkMetadata.getStatistics()));
                this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstChunkMetadata.getStatistics()), false);
                if (!this.firstChunkMetadata.equals(this.cachedChunkMetadata.peek())) continue;
                this.firstChunkMetadata = this.cachedChunkMetadata.poll();
                break;
            }
        }
    }

    private void unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(long endpointTime, boolean init) throws IOException {
        while (!this.seqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics())) {
            this.unpackOneTimeSeriesMetadata(this.seqTimeSeriesMetadata.remove(0));
        }
        while (!this.unSeqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics())) {
            this.unpackOneTimeSeriesMetadata(this.unSeqTimeSeriesMetadata.poll());
        }
        if (this.firstTimeSeriesMetadata != null && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.firstTimeSeriesMetadata.getStatistics())) {
            this.unpackOneTimeSeriesMetadata(this.firstTimeSeriesMetadata);
            this.firstTimeSeriesMetadata = null;
        }
        if (init && this.firstChunkMetadata == null && !this.cachedChunkMetadata.isEmpty()) {
            this.firstChunkMetadata = this.cachedChunkMetadata.poll();
        }
    }

    protected void unpackOneTimeSeriesMetadata(ITimeSeriesMetadata timeSeriesMetadata) throws IOException {
        List<IChunkMetadata> chunkMetadataList = FileLoaderUtils.loadChunkMetadataList(timeSeriesMetadata);
        chunkMetadataList.forEach(chunkMetadata -> chunkMetadata.setSeq(timeSeriesMetadata.isSeq()));
        this.cachedChunkMetadata.addAll(chunkMetadataList);
    }

    boolean isChunkOverlapped() throws IOException {
        if (this.firstChunkMetadata == null) {
            throw new IOException("no first chunk");
        }
        Statistics chunkStatistics = this.firstChunkMetadata.getStatistics();
        return !this.cachedChunkMetadata.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)chunkStatistics, (Statistics<? extends Object>)this.cachedChunkMetadata.peek().getStatistics());
    }

    Statistics currentChunkStatistics() {
        return this.firstChunkMetadata.getStatistics();
    }

    protected Statistics currentChunkStatistics(int index) throws IOException {
        Preconditions.checkArgument((index == 0 ? 1 : 0) != 0, (Object)"Only one sensor in non-aligned SeriesScanUtil.");
        return this.currentChunkStatistics();
    }

    protected Statistics currentChunkTimeStatistics() throws IOException {
        return this.currentChunkStatistics();
    }

    boolean currentChunkModified() throws IOException {
        if (this.firstChunkMetadata == null) {
            throw new IOException("no first chunk");
        }
        return this.firstChunkMetadata.isModified();
    }

    void skipCurrentChunk() {
        this.firstChunkMetadata = null;
    }

    public boolean hasNextPage() throws IOException {
        if (!this.paginationController.hasCurLimit()) {
            return false;
        }
        if (this.hasCachedNextOverlappedPage) {
            return true;
        }
        if ((this.mergeReader.hasNextTimeValuePair() || this.firstPageOverlapped()) && this.hasNextOverlappedPage()) {
            this.cachedTsBlock = this.nextOverlappedPage();
            if (this.cachedTsBlock != null && !this.cachedTsBlock.isEmpty()) {
                this.hasCachedNextOverlappedPage = true;
                return true;
            }
        }
        if (this.firstPageReader != null) {
            return true;
        }
        if (this.firstChunkMetadata != null) {
            this.unpackAllOverlappedChunkMetadataToPageReaders(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstChunkMetadata.getStatistics()), true);
        } else {
            this.initFirstPageReader();
        }
        if (this.isExistOverlappedPage()) {
            return true;
        }
        while (!(this.firstPageReader != null || this.seqPageReaders.isEmpty() && this.unSeqPageReaders.isEmpty())) {
            this.initFirstPageReader();
            if (!this.isExistOverlappedPage()) continue;
            return true;
        }
        return this.firstPageReader != null;
    }

    private boolean isExistOverlappedPage() throws IOException {
        if (this.firstPageOverlapped() && this.hasNextOverlappedPage()) {
            this.cachedTsBlock = this.nextOverlappedPage();
            if (this.cachedTsBlock != null && !this.cachedTsBlock.isEmpty()) {
                this.hasCachedNextOverlappedPage = true;
                return true;
            }
        }
        return false;
    }

    private boolean firstPageOverlapped() throws IOException {
        if (this.firstPageReader == null) {
            return false;
        }
        long endpointTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstPageReader.getStatistics());
        this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(endpointTime);
        this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(endpointTime, false);
        this.unpackAllOverlappedChunkMetadataToPageReaders(endpointTime, false);
        return !this.seqPageReaders.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)this.firstPageReader.getStatistics(), (Statistics<? extends Object>)this.seqPageReaders.get(0).getStatistics()) || !this.unSeqPageReaders.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)this.firstPageReader.getStatistics(), (Statistics<? extends Object>)this.unSeqPageReaders.peek().getStatistics()) || this.mergeReader.hasNextTimeValuePair() && this.orderUtils.isOverlapped(this.mergeReader.currentTimeValuePair().getTimestamp(), (Statistics<? extends Object>)this.firstPageReader.getStatistics());
    }

    private void unpackAllOverlappedChunkMetadataToPageReaders(long endpointTime, boolean init) throws IOException {
        if (this.firstChunkMetadata != null && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.firstChunkMetadata.getStatistics())) {
            this.unpackOneChunkMetaData(this.firstChunkMetadata);
            this.firstChunkMetadata = null;
        }
        boolean hasMeetSeq = false;
        while (!(this.cachedChunkMetadata.isEmpty() || !this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.cachedChunkMetadata.peek().getStatistics()) || this.cachedChunkMetadata.peek().isSeq() && hasMeetSeq)) {
            if (this.cachedChunkMetadata.peek().isSeq()) {
                hasMeetSeq = true;
            }
            this.unpackOneChunkMetaData(this.cachedChunkMetadata.poll());
        }
        if (!(!init || this.firstPageReader != null || this.seqPageReaders.isEmpty() && this.unSeqPageReaders.isEmpty())) {
            this.initFirstPageReader();
        }
    }

    private void unpackOneChunkMetaData(IChunkMetadata chunkMetaData) throws IOException {
        List<IPageReader> pageReaderList = FileLoaderUtils.loadPageReaderList(chunkMetaData, this.getGlobalTimeFilter());
        pageReaderList.forEach(p -> p.initTsBlockBuilder(this.getTsDataTypeList()));
        if (chunkMetaData.isSeq()) {
            if (this.orderUtils.getAscending()) {
                for (IPageReader iPageReader : pageReaderList) {
                    this.seqPageReaders.add(new VersionPageReader(chunkMetaData.getVersion(), chunkMetaData.getOffsetOfChunkHeader(), iPageReader, true));
                }
            } else {
                for (int i = pageReaderList.size() - 1; i >= 0; --i) {
                    this.seqPageReaders.add(new VersionPageReader(chunkMetaData.getVersion(), chunkMetaData.getOffsetOfChunkHeader(), pageReaderList.get(i), true));
                }
            }
        } else {
            pageReaderList.forEach(pageReader -> this.unSeqPageReaders.add(new VersionPageReader(chunkMetaData.getVersion(), chunkMetaData.getOffsetOfChunkHeader(), (IPageReader)pageReader, false)));
        }
    }

    boolean isPageOverlapped() throws IOException {
        if (this.hasCachedNextOverlappedPage) {
            return true;
        }
        if (this.mergeReader.hasNextTimeValuePair() && (this.orderUtils.getAscending() && this.mergeReader.currentTimeValuePair().getTimestamp() <= this.firstPageReader.getStatistics().getEndTime() || !this.orderUtils.getAscending() && this.mergeReader.currentTimeValuePair().getTimestamp() >= this.firstPageReader.getStatistics().getStartTime())) {
            throw new IOException("overlapped data should be consumed first");
        }
        Statistics firstPageStatistics = this.firstPageReader.getStatistics();
        return !this.unSeqPageReaders.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)firstPageStatistics, (Statistics<? extends Object>)this.unSeqPageReaders.peek().getStatistics());
    }

    Statistics currentPageStatistics() {
        if (this.firstPageReader == null) {
            return null;
        }
        return this.firstPageReader.getStatistics();
    }

    protected Statistics currentPageStatistics(int index) throws IOException {
        Preconditions.checkArgument((index == 0 ? 1 : 0) != 0, (Object)"Only one sensor in non-aligned SeriesScanUtil.");
        return this.currentPageStatistics();
    }

    protected Statistics currentPageTimeStatistics() throws IOException {
        return this.currentPageStatistics();
    }

    boolean currentPageModified() throws IOException {
        if (this.firstPageReader == null) {
            throw new IOException("no first page");
        }
        return this.firstPageReader.isModified();
    }

    void skipCurrentPage() {
        this.firstPageReader = null;
    }

    public TsBlock nextPage() throws IOException {
        TsBlock tsBlock;
        if (this.hasCachedNextOverlappedPage) {
            this.hasCachedNextOverlappedPage = false;
            TsBlock res = this.cachedTsBlock;
            this.cachedTsBlock = null;
            return res;
        }
        Filter queryFilter = this.scanOptions.getQueryFilter();
        if (queryFilter != null) {
            this.firstPageReader.setFilter(queryFilter);
        }
        if (this.orderUtils.getAscending()) {
            this.firstPageReader.setLimitOffset(this.paginationController);
            tsBlock = this.firstPageReader.getAllSatisfiedPageData(this.orderUtils.getAscending());
        } else {
            tsBlock = this.paginationController.applyTsBlock(this.firstPageReader.getAllSatisfiedPageData(this.orderUtils.getAscending()));
        }
        this.firstPageReader = null;
        return tsBlock;
    }

    /*
     * Exception decompiling
     */
    private boolean hasNextOverlappedPage() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long updateEndPointTime(long currentPageEndPointTime, VersionPageReader pageReader) {
        if (this.orderUtils.getAscending()) {
            return Math.min(currentPageEndPointTime, pageReader.getStatistics().getEndTime());
        }
        return Math.max(currentPageEndPointTime, pageReader.getStatistics().getStartTime());
    }

    private void tryToPutAllDirectlyOverlappedUnseqPageReadersIntoMergeReader() throws IOException {
        if (this.firstPageReader == null && this.unSeqPageReaders.isEmpty() && this.seqPageReaders.isEmpty()) {
            return;
        }
        if (this.firstPageReader == null) {
            this.initFirstPageReader();
        }
        long currentPageEndpointTime = this.mergeReader.hasNextTimeValuePair() ? this.mergeReader.getCurrentReadStopTime() : this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstPageReader.getStatistics());
        this.unpackAllOverlappedUnseqPageReadersToMergeReader(currentPageEndpointTime);
    }

    private void initFirstPageReader() throws IOException {
        while (this.firstPageReader == null) {
            VersionPageReader firstPageReader = this.getFirstPageReaderFromCachedReaders();
            if (firstPageReader != null) {
                long overlapCheckTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)firstPageReader.getStatistics());
                this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(overlapCheckTime);
                this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(overlapCheckTime, false);
                this.unpackAllOverlappedChunkMetadataToPageReaders(overlapCheckTime, false);
                if (!firstPageReader.equals(this.getFirstPageReaderFromCachedReaders())) continue;
                this.firstPageReader = firstPageReader;
                if (!this.seqPageReaders.isEmpty() && firstPageReader.equals(this.seqPageReaders.get(0))) {
                    this.seqPageReaders.remove(0);
                    break;
                }
                if (this.unSeqPageReaders.isEmpty() || !firstPageReader.equals(this.unSeqPageReaders.peek())) continue;
                this.unSeqPageReaders.poll();
                break;
            }
            return;
        }
    }

    private VersionPageReader getFirstPageReaderFromCachedReaders() {
        VersionPageReader firstPageReader = null;
        if (!this.seqPageReaders.isEmpty() && !this.unSeqPageReaders.isEmpty()) {
            firstPageReader = this.orderUtils.isTakeSeqAsFirst((Statistics<? extends Object>)this.seqPageReaders.get(0).getStatistics(), (Statistics<? extends Object>)this.unSeqPageReaders.peek().getStatistics()) ? this.seqPageReaders.get(0) : this.unSeqPageReaders.peek();
        } else if (!this.seqPageReaders.isEmpty()) {
            firstPageReader = this.seqPageReaders.get(0);
        } else if (!this.unSeqPageReaders.isEmpty()) {
            firstPageReader = this.unSeqPageReaders.peek();
        }
        return firstPageReader;
    }

    private void unpackAllOverlappedUnseqPageReadersToMergeReader(long endpointTime) throws IOException {
        while (!this.unSeqPageReaders.isEmpty() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.unSeqPageReaders.peek().data.getStatistics())) {
            this.putPageReaderToMergeReader(this.unSeqPageReaders.poll());
        }
        if (this.firstPageReader != null && !this.firstPageReader.isSeq() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.firstPageReader.getStatistics())) {
            this.putPageReaderToMergeReader(this.firstPageReader);
            this.firstPageReader = null;
        }
    }

    private void putPageReaderToMergeReader(VersionPageReader pageReader) throws IOException {
        this.mergeReader.addReader(this.getPointReader(pageReader.getAllSatisfiedPageData(this.orderUtils.getAscending())), pageReader.version, this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)pageReader.getStatistics()), this.context);
    }

    private TsBlock nextOverlappedPage() throws IOException {
        if (this.hasCachedNextOverlappedPage || this.hasNextOverlappedPage()) {
            this.hasCachedNextOverlappedPage = false;
            return this.cachedTsBlock;
        }
        throw new IOException("No more batch data");
    }

    protected void tryToUnpackAllOverlappedFilesToTimeSeriesMetadata() throws IOException {
        while (this.seqTimeSeriesMetadata.isEmpty() && this.orderUtils.hasNextSeqResource()) {
            this.unpackSeqTsFileResource();
        }
        while (this.unSeqTimeSeriesMetadata.isEmpty() && this.orderUtils.hasNextUnseqResource()) {
            this.unpackUnseqTsFileResource();
        }
        long endTime = -1L;
        if (!this.seqTimeSeriesMetadata.isEmpty() && this.unSeqTimeSeriesMetadata.isEmpty()) {
            endTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics());
        } else if (this.seqTimeSeriesMetadata.isEmpty() && !this.unSeqTimeSeriesMetadata.isEmpty()) {
            endTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics());
        } else if (!this.seqTimeSeriesMetadata.isEmpty()) {
            endTime = this.orderUtils.getCurrentEndPoint((Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics(), (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics());
        }
        if (endTime != -1L) {
            this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(endTime);
        }
        if (!this.seqTimeSeriesMetadata.isEmpty() && this.unSeqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.seqTimeSeriesMetadata.remove(0);
        } else if (this.seqTimeSeriesMetadata.isEmpty() && !this.unSeqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.unSeqTimeSeriesMetadata.poll();
        } else if (!this.seqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.orderUtils.isTakeSeqAsFirst((Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics(), (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics()) ? this.seqTimeSeriesMetadata.remove(0) : this.unSeqTimeSeriesMetadata.poll();
        }
    }

    protected void filterFirstTimeSeriesMetadata() throws IOException {
        if (this.firstTimeSeriesMetadata != null && !this.isFileOverlapped() && !this.firstTimeSeriesMetadata.isModified()) {
            Filter queryFilter = this.scanOptions.getQueryFilter();
            Statistics statistics = this.firstTimeSeriesMetadata.getStatistics();
            if (queryFilter == null || queryFilter.allSatisfy(statistics)) {
                long rowCount = statistics.getCount();
                if (this.paginationController.hasCurOffset(rowCount)) {
                    this.skipCurrentFile();
                    this.paginationController.consumeOffset(rowCount);
                }
            } else if (!queryFilter.satisfy(statistics)) {
                this.skipCurrentFile();
            }
        }
    }

    protected void unpackAllOverlappedTsFilesToTimeSeriesMetadata(long endpointTime) throws IOException {
        while (this.orderUtils.hasNextUnseqResource() && this.orderUtils.isOverlapped(endpointTime, this.orderUtils.getNextUnseqFileResource(false))) {
            this.unpackUnseqTsFileResource();
        }
        while (this.orderUtils.hasNextSeqResource() && this.orderUtils.isOverlapped(endpointTime, this.orderUtils.getNextSeqFileResource(false))) {
            this.unpackSeqTsFileResource();
        }
    }

    private void unpackSeqTsFileResource() throws IOException {
        ITimeSeriesMetadata timeseriesMetadata = this.loadTimeSeriesMetadata(this.orderUtils.getNextSeqFileResource(true), this.seriesPath, this.context, this.getGlobalTimeFilter(), this.scanOptions.getAllSensors());
        if (timeseriesMetadata != null) {
            timeseriesMetadata.setSeq(true);
            this.seqTimeSeriesMetadata.add(timeseriesMetadata);
        }
    }

    private void unpackUnseqTsFileResource() throws IOException {
        ITimeSeriesMetadata timeseriesMetadata = this.loadTimeSeriesMetadata(this.orderUtils.getNextUnseqFileResource(true), this.seriesPath, this.context, this.getGlobalTimeFilter(), this.scanOptions.getAllSensors());
        if (timeseriesMetadata != null) {
            timeseriesMetadata.setModified(true);
            timeseriesMetadata.setSeq(false);
            this.unSeqTimeSeriesMetadata.add(timeseriesMetadata);
        }
    }

    protected ITimeSeriesMetadata loadTimeSeriesMetadata(TsFileResource resource, PartialPath seriesPath, QueryContext context, Filter filter, Set<String> allSensors) throws IOException {
        return FileLoaderUtils.loadTimeSeriesMetadata(resource, seriesPath, context, filter, allSensors);
    }

    protected List<TSDataType> getTsDataTypeList() {
        return Collections.singletonList(this.dataType);
    }

    protected IPointReader getPointReader(TsBlock tsBlock) {
        return tsBlock.getTsBlockSingleColumnIterator();
    }

    Filter getGlobalTimeFilter() {
        return this.scanOptions.getGlobalTimeFilter();
    }

    class AscTimeOrderUtils
    implements TimeOrderUtils {
        AscTimeOrderUtils() {
        }

        public long getOrderTime(Statistics statistics) {
            return statistics.getStartTime();
        }

        @Override
        public long getOrderTime(TsFileResource fileResource) {
            return fileResource.getStartTime(SeriesScanUtil.this.seriesPath.getDevice());
        }

        public long getOverlapCheckTime(Statistics range) {
            return range.getEndTime();
        }

        public boolean isOverlapped(Statistics left, Statistics right) {
            return left.getEndTime() >= right.getStartTime();
        }

        public boolean isOverlapped(long time, Statistics right) {
            return time >= right.getStartTime();
        }

        @Override
        public boolean isOverlapped(long time, TsFileResource right) {
            return time >= right.getStartTime(SeriesScanUtil.this.seriesPath.getDevice());
        }

        @Override
        public <T> Comparator<T> comparingLong(ToLongFunction<? super T> keyExtractor) {
            Objects.requireNonNull(keyExtractor);
            return (Comparator & Serializable)(c1, c2) -> Long.compare(keyExtractor.applyAsLong(c1), keyExtractor.applyAsLong(c2));
        }

        @Override
        public long getCurrentEndPoint(long time, Statistics<? extends Object> statistics) {
            return Math.min(time, statistics.getEndTime());
        }

        @Override
        public long getCurrentEndPoint(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return Math.min(seqStatistics.getEndTime(), unseqStatistics.getEndTime());
        }

        @Override
        public boolean isExcessEndpoint(long time, long endpointTime) {
            return time > endpointTime;
        }

        @Override
        public boolean isTakeSeqAsFirst(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return seqStatistics.getStartTime() < unseqStatistics.getStartTime();
        }

        @Override
        public boolean getAscending() {
            return true;
        }

        @Override
        public boolean hasNextSeqResource() {
            TsFileResource tsFileResource;
            while (SeriesScanUtil.this.dataSource.hasNextSeqResource(SeriesScanUtil.this.curSeqFileIndex, this.getAscending()) && ((tsFileResource = SeriesScanUtil.this.dataSource.getSeqResourceByIndex(SeriesScanUtil.this.curSeqFileIndex)) == null || !tsFileResource.isSatisfied(SeriesScanUtil.this.seriesPath.getDevice(), SeriesScanUtil.this.getGlobalTimeFilter(), true, false))) {
                ++SeriesScanUtil.this.curSeqFileIndex;
            }
            return SeriesScanUtil.this.dataSource.hasNextSeqResource(SeriesScanUtil.this.curSeqFileIndex, this.getAscending());
        }

        @Override
        public boolean hasNextUnseqResource() {
            TsFileResource tsFileResource;
            while (SeriesScanUtil.this.dataSource.hasNextUnseqResource(SeriesScanUtil.this.curUnseqFileIndex) && ((tsFileResource = SeriesScanUtil.this.dataSource.getUnseqResourceByIndex(SeriesScanUtil.this.curUnseqFileIndex)) == null || !tsFileResource.isSatisfied(SeriesScanUtil.this.seriesPath.getDevice(), SeriesScanUtil.this.getGlobalTimeFilter(), false, false))) {
                ++SeriesScanUtil.this.curUnseqFileIndex;
            }
            return SeriesScanUtil.this.dataSource.hasNextUnseqResource(SeriesScanUtil.this.curUnseqFileIndex);
        }

        @Override
        public TsFileResource getNextSeqFileResource(boolean isDelete) {
            TsFileResource tsFileResource = SeriesScanUtil.this.dataSource.getSeqResourceByIndex(SeriesScanUtil.this.curSeqFileIndex);
            if (isDelete) {
                ++SeriesScanUtil.this.curSeqFileIndex;
            }
            return tsFileResource;
        }

        @Override
        public TsFileResource getNextUnseqFileResource(boolean isDelete) {
            TsFileResource tsFileResource = SeriesScanUtil.this.dataSource.getUnseqResourceByIndex(SeriesScanUtil.this.curUnseqFileIndex);
            if (isDelete) {
                ++SeriesScanUtil.this.curUnseqFileIndex;
            }
            return tsFileResource;
        }

        @Override
        public void setCurSeqFileIndex(QueryDataSource dataSource) {
            SeriesScanUtil.this.curSeqFileIndex = 0;
        }
    }

    class DescTimeOrderUtils
    implements TimeOrderUtils {
        DescTimeOrderUtils() {
        }

        public long getOrderTime(Statistics statistics) {
            return statistics.getEndTime();
        }

        @Override
        public long getOrderTime(TsFileResource fileResource) {
            return fileResource.getEndTime(SeriesScanUtil.this.seriesPath.getDevice());
        }

        public long getOverlapCheckTime(Statistics range) {
            return range.getStartTime();
        }

        public boolean isOverlapped(Statistics left, Statistics right) {
            return left.getStartTime() <= right.getEndTime();
        }

        public boolean isOverlapped(long time, Statistics right) {
            return time <= right.getEndTime();
        }

        @Override
        public boolean isOverlapped(long time, TsFileResource right) {
            return time <= right.getEndTime(SeriesScanUtil.this.seriesPath.getDevice());
        }

        @Override
        public <T> Comparator<T> comparingLong(ToLongFunction<? super T> keyExtractor) {
            Objects.requireNonNull(keyExtractor);
            return (Comparator & Serializable)(c1, c2) -> Long.compare(keyExtractor.applyAsLong(c2), keyExtractor.applyAsLong(c1));
        }

        @Override
        public long getCurrentEndPoint(long time, Statistics<? extends Object> statistics) {
            return Math.max(time, statistics.getStartTime());
        }

        @Override
        public long getCurrentEndPoint(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return Math.max(seqStatistics.getStartTime(), unseqStatistics.getStartTime());
        }

        @Override
        public boolean isExcessEndpoint(long time, long endpointTime) {
            return time < endpointTime;
        }

        @Override
        public boolean isTakeSeqAsFirst(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return seqStatistics.getEndTime() > unseqStatistics.getEndTime();
        }

        @Override
        public boolean getAscending() {
            return false;
        }

        @Override
        public boolean hasNextSeqResource() {
            TsFileResource tsFileResource;
            while (SeriesScanUtil.this.dataSource.hasNextSeqResource(SeriesScanUtil.this.curSeqFileIndex, this.getAscending()) && ((tsFileResource = SeriesScanUtil.this.dataSource.getSeqResourceByIndex(SeriesScanUtil.this.curSeqFileIndex)) == null || !tsFileResource.isSatisfied(SeriesScanUtil.this.seriesPath.getDevice(), SeriesScanUtil.this.getGlobalTimeFilter(), true, false))) {
                --SeriesScanUtil.this.curSeqFileIndex;
            }
            return SeriesScanUtil.this.dataSource.hasNextSeqResource(SeriesScanUtil.this.curSeqFileIndex, this.getAscending());
        }

        @Override
        public boolean hasNextUnseqResource() {
            TsFileResource tsFileResource;
            while (SeriesScanUtil.this.dataSource.hasNextUnseqResource(SeriesScanUtil.this.curUnseqFileIndex) && ((tsFileResource = SeriesScanUtil.this.dataSource.getUnseqResourceByIndex(SeriesScanUtil.this.curUnseqFileIndex)) == null || !tsFileResource.isSatisfied(SeriesScanUtil.this.seriesPath.getDevice(), SeriesScanUtil.this.getGlobalTimeFilter(), false, false))) {
                ++SeriesScanUtil.this.curUnseqFileIndex;
            }
            return SeriesScanUtil.this.dataSource.hasNextUnseqResource(SeriesScanUtil.this.curUnseqFileIndex);
        }

        @Override
        public TsFileResource getNextSeqFileResource(boolean isDelete) {
            TsFileResource tsFileResource = SeriesScanUtil.this.dataSource.getSeqResourceByIndex(SeriesScanUtil.this.curSeqFileIndex);
            if (isDelete) {
                --SeriesScanUtil.this.curSeqFileIndex;
            }
            return tsFileResource;
        }

        @Override
        public TsFileResource getNextUnseqFileResource(boolean isDelete) {
            TsFileResource tsFileResource = SeriesScanUtil.this.dataSource.getUnseqResourceByIndex(SeriesScanUtil.this.curUnseqFileIndex);
            if (isDelete) {
                ++SeriesScanUtil.this.curUnseqFileIndex;
            }
            return tsFileResource;
        }

        @Override
        public void setCurSeqFileIndex(QueryDataSource dataSource) {
            SeriesScanUtil.this.curSeqFileIndex = dataSource.getSeqResourcesSize() - 1;
        }
    }

    public static interface TimeOrderUtils {
        public long getOrderTime(Statistics<? extends Object> var1);

        public long getOrderTime(TsFileResource var1);

        public long getOverlapCheckTime(Statistics<? extends Object> var1);

        public boolean isOverlapped(Statistics<? extends Object> var1, Statistics<? extends Object> var2);

        public boolean isOverlapped(long var1, Statistics<? extends Object> var3);

        public boolean isOverlapped(long var1, TsFileResource var3);

        public <T> Comparator<T> comparingLong(ToLongFunction<? super T> var1);

        public long getCurrentEndPoint(long var1, Statistics<? extends Object> var3);

        public long getCurrentEndPoint(Statistics<? extends Object> var1, Statistics<? extends Object> var2);

        public boolean isExcessEndpoint(long var1, long var3);

        public boolean isTakeSeqAsFirst(Statistics<? extends Object> var1, Statistics<? extends Object> var2);

        public boolean getAscending();

        public boolean hasNextSeqResource();

        public boolean hasNextUnseqResource();

        public TsFileResource getNextSeqFileResource(boolean var1);

        public TsFileResource getNextUnseqFileResource(boolean var1);

        public void setCurSeqFileIndex(QueryDataSource var1);
    }

    protected static class VersionPageReader {
        private final PriorityMergeReader.MergeReaderPriority version;
        private final IPageReader data;
        private final boolean isSeq;
        private final boolean isAligned;
        private final boolean isMem;

        VersionPageReader(long version, long offset, IPageReader data, boolean isSeq) {
            this.version = new PriorityMergeReader.MergeReaderPriority(version, offset);
            this.data = data;
            this.isSeq = isSeq;
            this.isAligned = data instanceof IAlignedPageReader;
            this.isMem = data instanceof MemPageReader || data instanceof MemAlignedPageReader;
        }

        Statistics getStatistics() {
            return this.data.getStatistics();
        }

        Statistics getStatistics(int index) throws IOException {
            if (!(this.data instanceof IAlignedPageReader)) {
                throw new IOException("Can only get statistics by index from AlignedPageReader");
            }
            return ((IAlignedPageReader)this.data).getStatistics(index);
        }

        Statistics getTimeStatistics() throws IOException {
            if (!(this.data instanceof IAlignedPageReader)) {
                throw new IOException("Can only get statistics of time column from AlignedPageReader");
            }
            return ((IAlignedPageReader)this.data).getTimeStatistics();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TsBlock getAllSatisfiedPageData(boolean ascending) throws IOException {
            TsBlock tsBlock;
            long startTime = System.nanoTime();
            try {
                TsBlock tsBlock2 = this.data.getAllSatisfiedData();
                if (!ascending) {
                    tsBlock2.reverse();
                }
                tsBlock = tsBlock2;
            }
            catch (Throwable throwable) {
                QUERY_METRICS.recordSeriesScanCost(this.isAligned ? (this.isMem ? "build_tsblock_from_page_reader_aligned_mem" : "build_tsblock_from_page_reader_aligned_disk") : (this.isMem ? "build_tsblock_from_page_reader_nonaligned_mem" : "build_tsblock_from_page_reader_nonaligned_disk"), System.nanoTime() - startTime);
                throw throwable;
            }
            QUERY_METRICS.recordSeriesScanCost(this.isAligned ? (this.isMem ? "build_tsblock_from_page_reader_aligned_mem" : "build_tsblock_from_page_reader_aligned_disk") : (this.isMem ? "build_tsblock_from_page_reader_nonaligned_mem" : "build_tsblock_from_page_reader_nonaligned_disk"), System.nanoTime() - startTime);
            return tsBlock;
        }

        void setFilter(Filter filter) {
            this.data.setFilter(filter);
        }

        boolean isModified() {
            return this.data.isModified();
        }

        public boolean isSeq() {
            return this.isSeq;
        }

        public void setLimitOffset(PaginationController paginationController) {
            this.data.setLimitOffset(paginationController);
        }
    }
}

