/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.query.info.ISchemaInfo;
import org.apache.iotdb.db.metadata.query.reader.ISchemaReader;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.mpp.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;
import org.apache.iotdb.tsfile.utils.Binary;

public class CountGroupByLevelScanOperator<T extends ISchemaInfo>
implements SourceOperator {
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private static final List<TSDataType> OUTPUT_DATA_TYPES = ImmutableList.of((Object)TSDataType.TEXT, (Object)TSDataType.INT64);
    private final PlanNodeId sourceId;
    private final OperatorContext operatorContext;
    private final int level;
    private final ISchemaSource<T> schemaSource;
    private ISchemaReader<T> schemaReader;

    public CountGroupByLevelScanOperator(PlanNodeId sourceId, OperatorContext operatorContext, int level, ISchemaSource<T> schemaSource) {
        this.sourceId = sourceId;
        this.operatorContext = operatorContext;
        this.level = level;
        this.schemaSource = schemaSource;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.generateResult();
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.schemaReader == null) {
            this.schemaReader = this.createTimeSeriesReader();
        }
        return this.schemaReader.hasNext();
    }

    public ISchemaReader<T> createTimeSeriesReader() {
        return this.schemaSource.getSchemaReader(((SchemaDriverContext)this.operatorContext.getDriverContext()).getSchemaRegion());
    }

    private TsBlock generateResult() {
        HashMap<PartialPath, Long> countMap = new HashMap<PartialPath, Long>();
        while (this.schemaReader.hasNext()) {
            ISchemaInfo schemaInfo = (ISchemaInfo)this.schemaReader.next();
            PartialPath path = schemaInfo.getPartialPath();
            if (path.getNodeLength() < this.level) continue;
            PartialPath levelPath = new PartialPath(Arrays.copyOf(path.getNodes(), this.level + 1));
            countMap.compute(levelPath, (k, v) -> {
                if (v == null) {
                    return 1L;
                }
                return v + 1L;
            });
            if (countMap.size() != 1000) continue;
        }
        if (!this.schemaReader.isSuccess()) {
            throw new RuntimeException(this.schemaReader.getFailure());
        }
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(OUTPUT_DATA_TYPES);
        for (Map.Entry entry : countMap.entrySet()) {
            tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
            tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(((PartialPath)entry.getKey()).getFullPath()));
            tsBlockBuilder.getColumnBuilder(1).writeLong(((Long)entry.getValue()).longValue());
            tsBlockBuilder.declarePosition();
        }
        return tsBlockBuilder.build();
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateMaxReturnSize() {
        return TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    @Override
    public void close() throws Exception {
        if (this.schemaReader != null) {
            this.schemaReader.close();
        }
    }
}

