/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.aggregation.slidingwindow.SlidingWindowAggregator;
import org.apache.iotdb.db.mpp.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.mpp.execution.operator.AggregationUtil;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.SingleInputAggregationOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public class SlidingWindowAggregationOperator
extends SingleInputAggregationOperator {
    private final ITimeRangeIterator timeRangeIterator;
    private TimeRange curTimeRange;
    private final ITimeRangeIterator subTimeRangeIterator;
    private TimeRange curSubTimeRange;

    public SlidingWindowAggregationOperator(OperatorContext operatorContext, List<Aggregator> aggregators, ITimeRangeIterator timeRangeIterator, Operator child, boolean ascending, GroupByTimeParameter groupByTimeParameter, long maxReturnSize) {
        super(operatorContext, aggregators, child, ascending, maxReturnSize);
        Preconditions.checkArgument((groupByTimeParameter != null ? 1 : 0) != 0, (Object)"GroupByTimeParameter cannot be null in SlidingWindowAggregationOperator");
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Aggregator aggregator : aggregators) {
            dataTypes.addAll(Arrays.asList(aggregator.getOutputType()));
        }
        this.resultTsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.timeRangeIterator = timeRangeIterator;
        this.subTimeRangeIterator = AggregationUtil.initTimeRangeIterator(groupByTimeParameter, ascending, true);
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.curTimeRange != null || this.timeRangeIterator.hasNextTimeRange();
    }

    @Override
    protected boolean calculateNextAggregationResult() throws Exception {
        if (this.curTimeRange == null && this.timeRangeIterator.hasNextTimeRange()) {
            this.curTimeRange = this.timeRangeIterator.nextTimeRange();
            for (Aggregator aggregator : this.aggregators) {
                ((SlidingWindowAggregator)aggregator).updateTimeRange(this.curTimeRange);
            }
        }
        while (!this.isCalculationDone()) {
            if (this.inputTsBlock == null) {
                if (this.child.hasNextWithTimer() && this.canCallNext) {
                    this.inputTsBlock = this.child.nextWithTimer();
                    this.canCallNext = false;
                } else {
                    if (!this.child.hasNextWithTimer()) break;
                    return false;
                }
            }
            this.calculateFromCachedData();
        }
        this.updateResultTsBlock();
        return true;
    }

    private boolean isCalculationDone() {
        if (this.curSubTimeRange == null && !this.subTimeRangeIterator.hasNextTimeRange()) {
            return true;
        }
        if (this.curSubTimeRange == null && this.subTimeRangeIterator.hasNextTimeRange()) {
            this.curSubTimeRange = this.subTimeRangeIterator.nextTimeRange();
        }
        return this.ascending ? this.curSubTimeRange.getMin() > this.curTimeRange.getMax() : this.curSubTimeRange.getMax() < this.curTimeRange.getMin();
    }

    private void calculateFromCachedData() {
        if (this.inputTsBlock == null || this.inputTsBlock.isEmpty()) {
            return;
        }
        for (Aggregator aggregator : this.aggregators) {
            ((SlidingWindowAggregator)aggregator).processTsBlock(this.inputTsBlock);
        }
        this.inputTsBlock = this.inputTsBlock.skipFirst();
        if (this.inputTsBlock.isEmpty()) {
            this.inputTsBlock = null;
        }
        this.curSubTimeRange = null;
    }

    @Override
    protected void updateResultTsBlock() {
        this.curTimeRange = null;
        AggregationUtil.appendAggregationResult(this.resultTsBlockBuilder, this.aggregators, this.timeRangeIterator.currentOutputTime());
    }
}

