/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.fragment;

import io.airlift.stats.CounterStat;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.execution.driver.IDriver;
import org.apache.iotdb.db.mpp.execution.exchange.sink.ISink;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.mpp.execution.schedule.IDriverScheduler;
import org.apache.iotdb.db.utils.SetThreadName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentInstanceExecution {
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentInstanceExecution.class);
    private final FragmentInstanceId instanceId;
    private final FragmentInstanceContext context;
    private List<IDriver> drivers;
    private ISink sink;
    private final FragmentInstanceStateMachine stateMachine;
    private long lastHeartbeat;

    public static FragmentInstanceExecution createFragmentInstanceExecution(IDriverScheduler scheduler, FragmentInstanceId instanceId, FragmentInstanceContext context, List<IDriver> drivers, ISink sinkHandle, FragmentInstanceStateMachine stateMachine, CounterStat failedInstances, long timeOut) {
        FragmentInstanceExecution execution = new FragmentInstanceExecution(instanceId, context, drivers, sinkHandle, stateMachine);
        execution.initialize(failedInstances, scheduler);
        LOGGER.debug("timeout is {}ms.", (Object)timeOut);
        scheduler.submitDrivers(instanceId.getQueryId(), drivers, timeOut);
        return execution;
    }

    private FragmentInstanceExecution(FragmentInstanceId instanceId, FragmentInstanceContext context, List<IDriver> drivers, ISink sink, FragmentInstanceStateMachine stateMachine) {
        this.instanceId = instanceId;
        this.context = context;
        this.drivers = drivers;
        this.sink = sink;
        this.stateMachine = stateMachine;
    }

    public void recordHeartbeat() {
        this.lastHeartbeat = System.currentTimeMillis();
    }

    public void setLastHeartbeat(long lastHeartbeat) {
        this.lastHeartbeat = lastHeartbeat;
    }

    public FragmentInstanceState getInstanceState() {
        return this.stateMachine.getState();
    }

    public FragmentInstanceInfo getInstanceInfo() {
        return new FragmentInstanceInfo(this.stateMachine.getState(), this.context.getEndTime(), this.context.getFailedCause(), this.context.getFailureInfoList());
    }

    public long getStartTime() {
        return this.context.getStartTime();
    }

    public FragmentInstanceStateMachine getStateMachine() {
        return this.stateMachine;
    }

    private void initialize(CounterStat failedInstances, IDriverScheduler scheduler) {
        Objects.requireNonNull(failedInstances, "failedInstances is null");
        this.stateMachine.addStateChangeListener(newState -> {
            try (SetThreadName threadName = new SetThreadName(this.instanceId.getFullId());){
                if (!newState.isDone()) {
                    return;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Enter the stateChangeListener");
                }
                if (newState == FragmentInstanceState.FAILED) {
                    failedInstances.update(1L);
                }
                if (newState.isFailed()) {
                    this.sink.abort();
                } else {
                    this.sink.close();
                }
                this.sink = null;
                for (IDriver driver : this.drivers) {
                    driver.close();
                }
                this.context.releaseResource();
                this.drivers = null;
                if (newState.isFailed()) {
                    scheduler.abortFragmentInstance(this.instanceId);
                }
            }
            catch (Throwable t) {
                try (SetThreadName threadName2 = new SetThreadName(this.instanceId.getFullId());){
                    LOGGER.error("Errors happened while trying to finish FI, resource may already leak!", t);
                }
            }
        });
    }
}

