/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SessionInfo {
    private final long sessionId;
    private final String userName;
    private final String zoneId;
    private IoTDBConstant.ClientVersion version = IoTDBConstant.ClientVersion.V_1_0;

    public SessionInfo(long sessionId, String userName, String zoneId) {
        this.sessionId = sessionId;
        this.userName = userName;
        this.zoneId = zoneId;
    }

    public SessionInfo(long sessionId, String userName, String zoneId, IoTDBConstant.ClientVersion version) {
        this.sessionId = sessionId;
        this.userName = userName;
        this.zoneId = zoneId;
        this.version = version;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public IoTDBConstant.ClientVersion getVersion() {
        return this.version;
    }

    public static SessionInfo deserializeFrom(ByteBuffer buffer) {
        long sessionId = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        String userName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        String zoneId = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        return new SessionInfo(sessionId, userName, zoneId);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((long)this.sessionId, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.userName, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.zoneId, (OutputStream)stream);
    }
}

