/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.rescon;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.metadata.rescon.CachedSchemaRegionStatistics;
import org.apache.iotdb.db.metadata.rescon.ISchemaEngineStatistics;
import org.apache.iotdb.db.metadata.rescon.ISchemaRegionStatistics;
import org.apache.iotdb.db.metadata.rescon.MemSchemaEngineStatistics;
import org.apache.iotdb.db.metadata.template.ClusterTemplateManager;

public class MemSchemaRegionStatistics
implements ISchemaRegionStatistics {
    protected MemSchemaEngineStatistics schemaEngineStatistics;
    private final int schemaRegionId;
    private final AtomicLong memoryUsage = new AtomicLong(0L);
    private final AtomicLong seriesNumber = new AtomicLong(0L);
    private final AtomicLong devicesNumber = new AtomicLong(0L);
    private final Map<Integer, Integer> templateUsage = new ConcurrentHashMap<Integer, Integer>();
    private long mLogLength = 0L;

    public MemSchemaRegionStatistics(int schemaRegionId, ISchemaEngineStatistics engineStatistics) {
        this.schemaEngineStatistics = engineStatistics.getAsMemSchemaEngineStatistics();
        this.schemaRegionId = schemaRegionId;
    }

    @Override
    public boolean isAllowToCreateNewSeries() {
        return this.schemaEngineStatistics.isAllowToCreateNewSeries();
    }

    public void requestMemory(long size) {
        this.memoryUsage.addAndGet(size);
        this.schemaEngineStatistics.requestMemory(size);
    }

    public void releaseMemory(long size) {
        this.memoryUsage.addAndGet(-size);
        this.schemaEngineStatistics.releaseMemory(size);
    }

    @Override
    public long getSeriesNumber() {
        return this.seriesNumber.get() + this.getTemplateSeriesNumber();
    }

    public void addTimeseries(long addedNum) {
        this.seriesNumber.addAndGet(addedNum);
        this.schemaEngineStatistics.addTimeseries(addedNum);
    }

    public void deleteTimeseries(long deletedNum) {
        this.seriesNumber.addAndGet(-deletedNum);
        this.schemaEngineStatistics.deleteTimeseries(deletedNum);
    }

    @Override
    public long getDevicesNumber() {
        return this.devicesNumber.get();
    }

    public void addDevice() {
        this.devicesNumber.incrementAndGet();
    }

    public void deleteDevice() {
        this.devicesNumber.decrementAndGet();
    }

    @Override
    public int getTemplateActivatedNumber() {
        return this.templateUsage.size();
    }

    @Override
    public long getTemplateSeriesNumber() {
        ClusterTemplateManager clusterTemplateManager = ClusterTemplateManager.getInstance();
        return this.templateUsage.entrySet().stream().mapToLong(i -> (long)clusterTemplateManager.getTemplate((Integer)i.getKey()).getMeasurementNumber() * (long)((Integer)i.getValue()).intValue()).sum();
    }

    public void activateTemplate(int templateId) {
        this.templateUsage.compute(templateId, (k, v) -> v == null ? 1 : v + 1);
        this.schemaEngineStatistics.activateTemplate(templateId);
    }

    public void deactivateTemplate(int templateId) {
        this.templateUsage.compute(templateId, (k, v) -> v == null || v == 1 ? null : Integer.valueOf(v - 1));
        this.schemaEngineStatistics.deactivateTemplate(templateId, 1);
    }

    @Override
    public long getRegionMemoryUsage() {
        return this.memoryUsage.get();
    }

    @Override
    public int getSchemaRegionId() {
        return this.schemaRegionId;
    }

    public void setMLogLength(long mLogLength) {
        this.mLogLength = mLogLength;
    }

    public long getMLogLength() {
        return this.mLogLength;
    }

    @Override
    public MemSchemaRegionStatistics getAsMemSchemaRegionStatistics() {
        return this;
    }

    @Override
    public CachedSchemaRegionStatistics getAsCachedSchemaRegionStatistics() {
        throw new UnsupportedOperationException("Wrong SchemaRegionStatistics Type");
    }

    @Override
    public void clear() {
        this.schemaEngineStatistics.releaseMemory(this.memoryUsage.get());
        this.schemaEngineStatistics.deleteTimeseries(this.seriesNumber.get());
        this.memoryUsage.getAndSet(0L);
        this.seriesNumber.getAndSet(0L);
        this.devicesNumber.getAndSet(0L);
        this.templateUsage.forEach((templateId, cnt) -> this.schemaEngineStatistics.deactivateTemplate((int)templateId, (int)cnt));
        this.templateUsage.clear();
    }
}

