/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol.IReleaseFlushStrategy;
import org.apache.iotdb.db.metadata.rescon.CachedSchemaEngineStatistics;

public class ReleaseFlushStrategySizeBasedImpl
implements IReleaseFlushStrategy {
    private final CachedSchemaEngineStatistics engineStatistics;
    private final long releaseThreshold;
    private final long flushThreshold;
    public static final double RELEASE_THRESHOLD_RATIO = 0.6;
    public static final double FLUSH_THRESHOLD_RATION = 0.75;

    public ReleaseFlushStrategySizeBasedImpl(CachedSchemaEngineStatistics engineStatistics) {
        this.engineStatistics = engineStatistics;
        long capacity = IoTDBDescriptor.getInstance().getConfig().getAllocateMemoryForSchemaRegion();
        this.releaseThreshold = (long)((double)capacity * 0.6);
        this.flushThreshold = (long)((double)capacity * 0.75);
    }

    @Override
    public boolean isExceedReleaseThreshold() {
        return this.engineStatistics.getMemoryUsage() > this.releaseThreshold;
    }

    @Override
    public boolean isExceedFlushThreshold() {
        return this.engineStatistics.getMemoryUsage() > this.flushThreshold;
    }
}

