/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.AboveDatabaseMNode;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MNodeUtils;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.estimator.BasicMNodSizeEstimator;
import org.apache.iotdb.db.metadata.mnode.estimator.IMNodeSizeEstimator;
import org.apache.iotdb.db.metadata.mnode.iterator.IMNodeIterator;
import org.apache.iotdb.db.metadata.mnode.iterator.MNodeIterator;
import org.apache.iotdb.db.metadata.mnode.iterator.MemoryTraverserIterator;
import org.apache.iotdb.db.metadata.mtree.snapshot.MemMTreeSnapshotUtil;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.rescon.DataNodeSchemaQuotaManager;
import org.apache.iotdb.db.metadata.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.db.metadata.template.Template;

public class MemMTreeStore
implements IMTreeStore {
    private final IMNodeSizeEstimator estimator = new BasicMNodSizeEstimator();
    private final DataNodeSchemaQuotaManager schemaQuotaManager = DataNodeSchemaQuotaManager.getInstance();
    private MemSchemaRegionStatistics regionStatistics;
    private IMNode root;

    public MemMTreeStore(PartialPath rootPath, boolean isStorageGroup) {
        this.root = isStorageGroup ? new StorageGroupMNode(null, rootPath.getTailNode(), CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs()) : new InternalMNode(null, "root");
    }

    public MemMTreeStore(PartialPath rootPath, boolean isStorageGroup, MemSchemaRegionStatistics regionStatistics) {
        this.root = isStorageGroup ? new StorageGroupMNode(null, rootPath.getTailNode(), CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs()) : new InternalMNode(null, "root");
        this.regionStatistics = regionStatistics;
    }

    private MemMTreeStore(IMNode root, MemSchemaRegionStatistics regionStatistics) {
        this.root = root;
        this.regionStatistics = regionStatistics;
    }

    @Override
    public IMNode generatePrefix(PartialPath storageGroupPath) {
        AboveDatabaseMNode res;
        String[] nodes = storageGroupPath.getNodes();
        AboveDatabaseMNode cur = res = new AboveDatabaseMNode(null, nodes[0]);
        for (int i = 1; i < nodes.length - 1; ++i) {
            AboveDatabaseMNode child = new AboveDatabaseMNode(cur, nodes[i]);
            cur.addChild(nodes[i], child);
            cur = child;
        }
        this.root.setParent(cur);
        cur.addChild(this.root);
        this.requestMemory(this.estimator.estimateSize(this.root));
        return res;
    }

    @Override
    public IMNode getRoot() {
        return this.root;
    }

    @Override
    public boolean hasChild(IMNode parent, String name) {
        return parent.hasChild(name);
    }

    @Override
    public IMNode getChild(IMNode parent, String name) {
        return parent.getChild(name);
    }

    @Override
    public IMNodeIterator getChildrenIterator(IMNode parent) {
        return new MNodeIterator(parent.getChildren().values().iterator());
    }

    @Override
    public IMNodeIterator getTraverserIterator(IMNode parent, Map<Integer, Template> templateMap, boolean skipPreDeletedSchema) throws MetadataException {
        if (parent.isEntity()) {
            MemoryTraverserIterator iterator = new MemoryTraverserIterator(this, parent.getAsEntityMNode(), templateMap);
            iterator.setSkipPreDeletedSchema(skipPreDeletedSchema);
            return iterator;
        }
        return this.getChildrenIterator(parent);
    }

    @Override
    public IMNode addChild(IMNode parent, String childName, IMNode child) {
        IMNode result = parent.addChild(childName, child);
        if (result == child) {
            this.requestMemory(this.estimator.estimateSize(child));
        }
        return result;
    }

    @Override
    public void deleteChild(IMNode parent, String childName) {
        this.releaseMemory(this.estimator.estimateSize(parent.deleteChild(childName)));
    }

    @Override
    public void updateMNode(IMNode node) {
    }

    @Override
    public IEntityMNode setToEntity(IMNode node) {
        IEntityMNode result = MNodeUtils.setToEntity(node);
        if (result != node) {
            this.regionStatistics.addDevice();
            this.requestMemory(IMNodeSizeEstimator.getEntityNodeBaseSize());
        }
        if (result.isStorageGroup()) {
            this.root = result;
        }
        return result;
    }

    @Override
    public IMNode setToInternal(IEntityMNode entityMNode) {
        IMNode result = MNodeUtils.setToInternal(entityMNode);
        if (result != entityMNode) {
            this.regionStatistics.deleteDevice();
            this.releaseMemory(IMNodeSizeEstimator.getEntityNodeBaseSize());
        }
        if (result.isStorageGroup()) {
            this.root = result;
        }
        return result;
    }

    @Override
    public void setAlias(IMeasurementMNode measurementMNode, String alias) {
        String existingAlias = measurementMNode.getAlias();
        if (existingAlias == null && alias == null) {
            return;
        }
        measurementMNode.setAlias(alias);
        this.updateMNode(measurementMNode);
        if (existingAlias != null && alias != null) {
            int delta = alias.length() - existingAlias.length();
            if (delta > 0) {
                this.requestMemory(delta);
            } else if (delta < 0) {
                this.releaseMemory(-delta);
            }
        } else if (alias == null) {
            this.releaseMemory(IMNodeSizeEstimator.getAliasBaseSize() + existingAlias.length());
        } else {
            this.requestMemory(IMNodeSizeEstimator.getAliasBaseSize() + alias.length());
        }
    }

    @Override
    public void pin(IMNode node) {
    }

    @Override
    public void unPin(IMNode node) {
    }

    @Override
    public void unPinPath(IMNode node) {
    }

    @Override
    public IMTreeStore getWithReentrantReadLock() {
        return this;
    }

    @Override
    public void clear() {
        this.root = new InternalMNode(null, "root");
    }

    @Override
    public boolean createSnapshot(File snapshotDir) {
        return MemMTreeSnapshotUtil.createSnapshot(snapshotDir, this);
    }

    public static MemMTreeStore loadFromSnapshot(File snapshotDir, Consumer<IMeasurementMNode> measurementProcess, Consumer<IEntityMNode> deviceProcess, MemSchemaRegionStatistics regionStatistics) throws IOException {
        return new MemMTreeStore(MemMTreeSnapshotUtil.loadSnapshot(snapshotDir, measurementProcess, deviceProcess, regionStatistics), regionStatistics);
    }

    private void requestMemory(int size) {
        if (this.regionStatistics != null) {
            this.regionStatistics.requestMemory(size);
        }
    }

    private void releaseMemory(int size) {
        if (this.regionStatistics != null) {
            this.regionStatistics.releaseMemory(size);
        }
    }
}

