/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.utils;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.db.engine.trigger.sink.exception.SinkException;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;

public class MQTTConnectionFactory
extends BasePooledObjectFactory<BlockingConnection> {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final long connectAttemptsMax;
    private final long reconnectDelay;
    private static final AtomicInteger atomicCount = new AtomicInteger();
    private static final String CLIENT_NAME = "MQTTClient";

    public MQTTConnectionFactory(String host, int port, String username, String password, long connectAttemptsMax, long reconnectDelay) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.connectAttemptsMax = connectAttemptsMax;
        this.reconnectDelay = reconnectDelay;
    }

    public BlockingConnection create() throws Exception {
        MQTT mqtt = new MQTT();
        mqtt.setClientId(CLIENT_NAME + atomicCount.incrementAndGet());
        mqtt.setHost(this.host, this.port);
        mqtt.setUserName(this.username);
        mqtt.setPassword(this.password);
        mqtt.setConnectAttemptsMax(this.connectAttemptsMax);
        mqtt.setReconnectDelay(this.reconnectDelay);
        BlockingConnection connection = mqtt.blockingConnection();
        try {
            connection.connect();
        }
        catch (Exception e) {
            if (connection != null) {
                if (connection.isConnected()) {
                    connection.disconnect();
                }
                connection.kill();
            }
            throw new SinkException("MQTT Connection activate error", e);
        }
        return connection;
    }

    public PooledObject<BlockingConnection> wrap(BlockingConnection blockingConnection) {
        return new DefaultPooledObject((Object)blockingConnection);
    }

    public boolean validateObject(PooledObject<BlockingConnection> p) {
        if (p == null) {
            return false;
        }
        BlockingConnection connection = (BlockingConnection)p.getObject();
        return connection != null && connection.isConnected();
    }

    public void destroyObject(PooledObject<BlockingConnection> p) throws Exception {
        if (p == null) {
            return;
        }
        BlockingConnection connection = (BlockingConnection)p.getObject();
        try {
            if (connection != null) {
                if (connection.isConnected()) {
                    connection.disconnect();
                }
                connection.kill();
            }
        }
        catch (Exception e) {
            throw new SinkException("MQTT connection destroy error", e);
        }
        super.destroyObject(p);
    }
}

