/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.execute.utils.writer;

import java.io.IOException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public abstract class AbstractInnerCompactionWriter
extends AbstractCompactionWriter {
    protected TsFileIOWriter fileWriter;
    protected boolean isEmptyFile;
    protected TsFileResource targetResource;
    protected long targetPageSize = TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
    protected long targetPagePointNum = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();

    protected AbstractInnerCompactionWriter(TsFileResource targetFileResource) throws IOException {
        long sizeForFileWriter = (long)((double)(SystemInfo.getInstance().getMemorySizeForCompaction() / (long)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount()) * IoTDBDescriptor.getInstance().getConfig().getChunkMetadataSizeProportion());
        boolean enableMemoryControl = IoTDBDescriptor.getInstance().getConfig().isEnableMemControl();
        this.fileWriter = new TsFileIOWriter(targetFileResource.getTsFile(), enableMemoryControl, sizeForFileWriter);
        this.targetResource = targetFileResource;
        this.isEmptyFile = true;
    }

    @Override
    public void startChunkGroup(String deviceId, boolean isAlign) throws IOException {
        this.fileWriter.startChunkGroup(deviceId);
        this.isAlign = isAlign;
        this.deviceId = deviceId;
    }

    @Override
    public void endChunkGroup() throws IOException {
        CompactionUtils.updateResource(this.targetResource, this.fileWriter, this.deviceId);
        this.fileWriter.endChunkGroup();
    }

    @Override
    public void endMeasurement(int subTaskId) throws IOException {
        this.sealChunk(this.fileWriter, this.chunkWriters[subTaskId], subTaskId);
    }

    @Override
    public void write(TimeValuePair timeValuePair, int subTaskId) throws IOException {
        this.writeDataPoint(timeValuePair.getTimestamp(), timeValuePair.getValue(), this.chunkWriters[subTaskId]);
        int n = subTaskId;
        this.chunkPointNumArray[n] = this.chunkPointNumArray[n] + 1;
        this.checkChunkSizeAndMayOpenANewChunk(this.fileWriter, this.chunkWriters[subTaskId], subTaskId, false);
        this.isEmptyFile = false;
    }

    @Override
    public abstract void write(TimeColumn var1, Column[] var2, int var3, int var4) throws IOException;

    @Override
    public void endFile() throws IOException {
        this.fileWriter.endFile();
        if (this.isEmptyFile) {
            this.targetResource.setStatus(TsFileResourceStatus.DELETED);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.fileWriter != null && this.fileWriter.canWrite()) {
            this.fileWriter.close();
        }
        this.fileWriter = null;
    }

    @Override
    public void checkAndMayFlushChunkMetadata() throws IOException {
        this.fileWriter.checkMetadataSizeAndMayFlush();
    }

    @Override
    public long getWriterSize() throws IOException {
        return this.fileWriter.getPos();
    }
}

