/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.execute.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.TsFileMetricManager;
import org.apache.iotdb.db.engine.compaction.execute.exception.CompactionExceptionHandler;
import org.apache.iotdb.db.engine.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.engine.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.execute.utils.log.CompactionLogger;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceList;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.service.metrics.recorder.CompactionMetricsManager;
import org.apache.iotdb.tsfile.exception.write.TsFileNotCompleteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerSpaceCompactionTask
extends AbstractCompactionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    protected List<TsFileResource> selectedTsFileResourceList;
    protected TsFileResource targetTsFileResource;
    protected boolean sequence;
    protected long selectedFileSize;
    protected int sumOfCompactionCount;
    protected long maxFileVersion;
    protected int maxCompactionCount;
    private File logFile;
    protected TsFileResourceList tsFileResourceList;
    protected List<TsFileResource> targetTsFileList;
    protected boolean[] isHoldingReadLock;
    protected boolean[] isHoldingWriteLock;

    public InnerSpaceCompactionTask(long timePartition, TsFileManager tsFileManager, List<TsFileResource> selectedTsFileResourceList, boolean sequence, ICompactionPerformer performer, AtomicInteger currentTaskNum, long serialId) {
        super(tsFileManager.getStorageGroupName(), tsFileManager.getDataRegionId(), timePartition, tsFileManager, currentTaskNum, serialId);
        this.selectedTsFileResourceList = selectedTsFileResourceList;
        this.sequence = sequence;
        this.performer = performer;
        this.isHoldingReadLock = new boolean[selectedTsFileResourceList.size()];
        this.isHoldingWriteLock = new boolean[selectedTsFileResourceList.size()];
        for (int i = 0; i < selectedTsFileResourceList.size(); ++i) {
            this.isHoldingWriteLock[i] = false;
            this.isHoldingReadLock[i] = false;
        }
        this.tsFileResourceList = sequence ? tsFileManager.getOrCreateSequenceListByTimePartition(timePartition) : tsFileManager.getOrCreateUnsequenceListByTimePartition(timePartition);
        this.hashCode = this.toString().hashCode();
        this.innerSeqTask = sequence;
        this.crossTask = false;
        this.collectSelectedFilesInfo();
        this.createSummary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doCompaction() {
        if (!this.tsFileManager.isAllowCompaction()) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        String dataDirectory = this.selectedTsFileResourceList.get(0).getTsFile().getParent();
        LOGGER.info("{}-{} [Compaction] {} InnerSpaceCompaction task starts with {} files, total file size is {} MB.", new Object[]{this.storageGroupName, this.dataRegionId, this.sequence ? "Sequence" : "Unsequence", this.selectedTsFileResourceList.size(), this.selectedFileSize / 1024L / 1024L});
        boolean isSuccess = true;
        try {
            this.targetTsFileResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(this.selectedTsFileResourceList, this.sequence);
            this.logFile = new File(dataDirectory + File.separator + this.targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
            try (CompactionLogger compactionLogger = new CompactionLogger(this.logFile);){
                this.targetTsFileList = new ArrayList<TsFileResource>(Collections.singletonList(this.targetTsFileResource));
                compactionLogger.logFiles(this.selectedTsFileResourceList, "source");
                compactionLogger.logFiles(this.targetTsFileList, "target");
                LOGGER.info("{}-{} [Compaction] compaction with {}", new Object[]{this.storageGroupName, this.dataRegionId, this.selectedTsFileResourceList});
                this.performer.setSourceFiles(this.selectedTsFileResourceList);
                this.performer.setTargetFiles(this.targetTsFileList);
                this.performer.setSummary(this.summary);
                this.performer.perform();
                CompactionUtils.moveTargetFile(this.targetTsFileList, true, this.storageGroupName + "-" + this.dataRegionId);
                LOGGER.info("{}-{} [InnerSpaceCompactionTask] start to rename mods file", (Object)this.storageGroupName, (Object)this.dataRegionId);
                CompactionUtils.combineModsInInnerCompaction(this.selectedTsFileResourceList, this.targetTsFileResource);
                if (Thread.currentThread().isInterrupted() || this.summary.isCancel()) {
                    throw new InterruptedException(String.format("%s-%s [Compaction] abort", this.storageGroupName, this.dataRegionId));
                }
                if (this.sequence) {
                    this.tsFileManager.replace(this.selectedTsFileResourceList, Collections.emptyList(), this.targetTsFileList, this.timePartition, true);
                } else {
                    this.tsFileManager.replace(Collections.emptyList(), this.selectedTsFileResourceList, this.targetTsFileList, this.timePartition, false);
                }
                if (this.targetTsFileResource.isDeleted()) {
                    compactionLogger.logFile(this.targetTsFileResource, "empty");
                }
                if (IoTDBDescriptor.getInstance().getConfig().isEnableCompactionValidation() && !CompactionUtils.validateTsFileResources(this.tsFileManager, this.storageGroupName, this.timePartition)) {
                    LOGGER.error("Failed to pass compaction validation, source files is: {}, target files is {}", this.selectedTsFileResourceList, this.targetTsFileList);
                    throw new RuntimeException("Failed to pass compaction validation");
                }
                LOGGER.info("{}-{} [Compaction] Compacted target files, try to get the write lock of source files", (Object)this.storageGroupName, (Object)this.dataRegionId);
                for (int i = 0; i < this.selectedTsFileResourceList.size(); ++i) {
                    this.selectedTsFileResourceList.get(i).readUnlock();
                    this.isHoldingReadLock[i] = false;
                    this.selectedTsFileResourceList.get(i).writeLock();
                    this.isHoldingWriteLock[i] = true;
                }
                if (this.targetTsFileResource.getTsFile().exists() && this.targetTsFileResource.getTsFile().length() < (long)"TsFile".getBytes().length * 2L + 1L) {
                    throw new TsFileNotCompleteException(String.format("target file %s is smaller than magic string and version number size", this.targetTsFileResource));
                }
                LOGGER.info("{}-{} [Compaction] compaction finish, start to delete old files", (Object)this.storageGroupName, (Object)this.dataRegionId);
                long totalSizeOfDeletedFile = 0L;
                for (TsFileResource resource : this.selectedTsFileResourceList) {
                    totalSizeOfDeletedFile += resource.getTsFileSize();
                }
                CompactionUtils.deleteTsFilesInDisk(this.selectedTsFileResourceList, this.storageGroupName + "-" + this.dataRegionId);
                CompactionUtils.deleteModificationForSourceFile(this.selectedTsFileResourceList, this.storageGroupName + "-" + this.dataRegionId);
                if (!this.targetTsFileResource.isDeleted()) {
                    TsFileMetricManager.getInstance().addFile(this.targetTsFileResource.getTsFile().length(), this.sequence);
                    this.targetTsFileResource.setStatus(TsFileResourceStatus.CLOSED);
                } else {
                    this.targetTsFileResource.remove();
                }
                TsFileMetricManager.getInstance().deleteFile(totalSizeOfDeletedFile, this.sequence, this.selectedTsFileResourceList.size());
                CompactionMetricsManager.getInstance().updateSummary(this.summary);
                double costTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                LOGGER.info("{}-{} [Compaction] {} InnerSpaceCompaction task finishes successfully, target file is {},time cost is {} s, compaction speed is {} MB/s, {}", new Object[]{this.storageGroupName, this.dataRegionId, this.sequence ? "Sequence" : "Unsequence", this.targetTsFileResource.getTsFile().getName(), costTime, (double)this.selectedFileSize / 1024.0 / 1024.0 / costTime, this.summary});
            }
            if (this.logFile.exists()) {
                FileUtils.delete((File)this.logFile);
            }
        }
        catch (Throwable throwable) {
            isSuccess = false;
            if (!(throwable instanceof InterruptedException)) {
                LOGGER.error("{}-{} [Compaction] Meet errors in inner space compaction.", new Object[]{this.storageGroupName, this.dataRegionId, throwable});
            } else {
                LOGGER.warn("{}-{} [Compaction] Compaction interrupted", (Object)this.storageGroupName, (Object)this.dataRegionId);
                Thread.interrupted();
            }
            if (this.isSequence()) {
                CompactionExceptionHandler.handleException(this.storageGroupName + "-" + this.dataRegionId, this.logFile, this.targetTsFileList, this.selectedTsFileResourceList, Collections.emptyList(), this.tsFileManager, this.timePartition, true, this.isSequence());
            }
            CompactionExceptionHandler.handleException(this.storageGroupName + "-" + this.dataRegionId, this.logFile, this.targetTsFileList, Collections.emptyList(), this.selectedTsFileResourceList, this.tsFileManager, this.timePartition, true, this.isSequence());
        }
        finally {
            this.releaseFileLocksAndResetMergingStatus();
            return isSuccess;
        }
    }

    @Override
    public boolean equalsOtherTask(AbstractCompactionTask otherTask) {
        if (!(otherTask instanceof InnerSpaceCompactionTask)) {
            return false;
        }
        InnerSpaceCompactionTask task = (InnerSpaceCompactionTask)otherTask;
        return this.selectedTsFileResourceList.equals(task.selectedTsFileResourceList) && this.performer.getClass().isInstance(task.performer);
    }

    @Override
    public void setSourceFilesToCompactionCandidate() {
        this.selectedTsFileResourceList.forEach(x -> x.setStatus(TsFileResourceStatus.COMPACTION_CANDIDATE));
    }

    private void collectSelectedFilesInfo() {
        this.selectedFileSize = 0L;
        this.sumOfCompactionCount = 0;
        this.maxFileVersion = -1L;
        this.maxCompactionCount = -1;
        if (this.selectedTsFileResourceList == null) {
            return;
        }
        for (TsFileResource resource : this.selectedTsFileResourceList) {
            try {
                this.selectedFileSize += resource.getTsFileSize();
                TsFileNameGenerator.TsFileName fileName = TsFileNameGenerator.getTsFileName(resource.getTsFile().getName());
                this.sumOfCompactionCount += fileName.getInnerCompactionCnt();
                if (fileName.getInnerCompactionCnt() > this.maxCompactionCount) {
                    this.maxCompactionCount = fileName.getInnerCompactionCnt();
                }
                if (fileName.getVersion() <= this.maxFileVersion) continue;
                this.maxFileVersion = fileName.getVersion();
            }
            catch (IOException e) {
                LOGGER.warn("Fail to get the tsfile name of {}", (Object)resource.getTsFile(), (Object)e);
            }
        }
    }

    public List<TsFileResource> getSelectedTsFileResourceList() {
        return this.selectedTsFileResourceList;
    }

    public boolean isSequence() {
        return this.sequence;
    }

    public long getSelectedFileSize() {
        return this.selectedFileSize;
    }

    public int getSumOfCompactionCount() {
        return this.sumOfCompactionCount;
    }

    public long getMaxFileVersion() {
        return this.maxFileVersion;
    }

    public String toString() {
        return this.storageGroupName + "-" + this.dataRegionId + "-" + this.timePartition + " task file num is " + this.selectedTsFileResourceList.size() + ", files is " + this.selectedTsFileResourceList + ", total compaction count is " + this.sumOfCompactionCount;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof InnerSpaceCompactionTask)) {
            return false;
        }
        return this.equalsOtherTask((InnerSpaceCompactionTask)other);
    }

    @Override
    public void resetCompactionCandidateStatusForAllSourceFiles() {
        this.selectedTsFileResourceList.forEach(x -> x.setStatus(TsFileResourceStatus.CLOSED));
    }

    protected void releaseFileLocksAndResetMergingStatus() {
        for (int i = 0; i < this.selectedTsFileResourceList.size(); ++i) {
            TsFileResource resource = this.selectedTsFileResourceList.get(i);
            if (this.isHoldingReadLock[i]) {
                resource.readUnlock();
            }
            if (this.isHoldingWriteLock[i]) {
                resource.writeUnlock();
            }
            try {
                if (resource.isDeleted()) continue;
                this.selectedTsFileResourceList.get(i).setStatus(TsFileResourceStatus.CLOSED);
                continue;
            }
            catch (Throwable e) {
                LOGGER.error("Exception occurs when resetting resource status", e);
            }
        }
    }

    @Override
    public boolean checkValidAndSetMerging() {
        if (!this.tsFileManager.isAllowCompaction()) {
            return false;
        }
        try {
            for (int i = 0; i < this.selectedTsFileResourceList.size(); ++i) {
                TsFileResource resource = this.selectedTsFileResourceList.get(i);
                resource.readLock();
                this.isHoldingReadLock[i] = true;
                if (!resource.isCompacting() && resource.isClosed() && resource.getTsFile().exists() && !resource.isDeleted()) continue;
                this.releaseFileLocksAndResetMergingStatus();
                return false;
            }
            for (TsFileResource resource : this.selectedTsFileResourceList) {
                resource.setStatus(TsFileResourceStatus.COMPACTING);
            }
        }
        catch (Throwable e) {
            this.releaseFileLocksAndResetMergingStatus();
            throw e;
        }
        return true;
    }

    @Override
    protected void createSummary() {
        this.summary = this.performer instanceof FastCompactionPerformer ? new FastCompactionTaskSummary() : new CompactionTaskSummary();
    }
}

