/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.binary.CompareBinaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class TypeInferenceUtils {
    private static final TSDataType booleanStringInferType = IoTDBDescriptor.getInstance().getConfig().getBooleanStringInferType();
    private static final TSDataType integerStringInferType = IoTDBDescriptor.getInstance().getConfig().getIntegerStringInferType();
    private static final TSDataType longStringInferType = IoTDBDescriptor.getInstance().getConfig().getLongStringInferType();
    private static final TSDataType floatingStringInferType = IoTDBDescriptor.getInstance().getConfig().getFloatingStringInferType();
    private static final TSDataType nanStringInferType = IoTDBDescriptor.getInstance().getConfig().getNanStringInferType();

    private TypeInferenceUtils() {
    }

    static boolean isNumber(String s) {
        if (s == null || s.equals("NaN")) {
            return false;
        }
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isBoolean(String s) {
        return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false");
    }

    private static boolean isConvertFloatPrecisionLack(String s) {
        try {
            return Long.parseLong(s) > 0x1000000L;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    public static TSDataType getPredictedDataType(Object value, boolean inferType) {
        if (inferType) {
            String strValue = value.toString();
            if (TypeInferenceUtils.isBoolean(strValue)) {
                return booleanStringInferType;
            }
            if (TypeInferenceUtils.isNumber(strValue)) {
                if (!strValue.contains(".")) {
                    if (TypeInferenceUtils.isConvertFloatPrecisionLack(StringUtils.trim((String)strValue))) {
                        return longStringInferType;
                    }
                    return integerStringInferType;
                }
                return floatingStringInferType;
            }
            if ("null".equals(strValue) || "NULL".equals(strValue)) {
                return null;
            }
            if ("NaN".equals(strValue)) {
                return nanStringInferType;
            }
            return TSDataType.TEXT;
        }
        if (value instanceof Boolean) {
            return TSDataType.BOOLEAN;
        }
        if (value instanceof Integer) {
            return TSDataType.INT32;
        }
        if (value instanceof Long) {
            return TSDataType.INT64;
        }
        if (value instanceof Float) {
            return TSDataType.FLOAT;
        }
        if (value instanceof Double) {
            return TSDataType.DOUBLE;
        }
        return TSDataType.TEXT;
    }

    public static TSDataType getAggrDataType(String aggrFuncName, TSDataType dataType) {
        if (aggrFuncName == null) {
            throw new IllegalArgumentException("AggregateFunction Name must not be null");
        }
        TypeInferenceUtils.verifyIsAggregationDataTypeMatched(aggrFuncName, dataType);
        switch (aggrFuncName.toLowerCase()) {
            case "min_time": 
            case "max_time": 
            case "count": 
            case "count_if": {
                return TSDataType.INT64;
            }
            case "min_value": 
            case "last_value": 
            case "first_value": 
            case "max_value": 
            case "extreme": {
                return dataType;
            }
            case "avg": 
            case "sum": {
                return TSDataType.DOUBLE;
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation function: " + aggrFuncName);
    }

    private static void verifyIsAggregationDataTypeMatched(String aggrFuncName, TSDataType dataType) {
        if (dataType == null) {
            return;
        }
        switch (aggrFuncName.toLowerCase()) {
            case "avg": 
            case "sum": 
            case "extreme": 
            case "min_value": 
            case "max_value": {
                if (dataType.isNumeric()) {
                    return;
                }
                throw new SemanticException("Aggregate functions [AVG, SUM, EXTREME, MIN_VALUE, MAX_VALUE] only support numeric data types [INT32, INT64, FLOAT, DOUBLE]");
            }
            case "count": 
            case "min_time": 
            case "max_time": 
            case "first_value": 
            case "last_value": {
                return;
            }
            case "count_if": {
                if (dataType != TSDataType.BOOLEAN) {
                    throw new SemanticException(String.format("Input series of Aggregation function [%s] only supports data type [BOOLEAN]", aggrFuncName));
                }
                return;
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation function: " + aggrFuncName);
    }

    public static void bindTypeForAggregationNonSeriesInputExpressions(String functionName, List<Expression> inputExpressions, List<List<Expression>> outputExpressionLists) {
        switch (functionName.toLowerCase()) {
            case "avg": 
            case "sum": 
            case "extreme": 
            case "min_value": 
            case "max_value": 
            case "count": 
            case "min_time": 
            case "max_time": 
            case "first_value": 
            case "last_value": {
                return;
            }
            case "count_if": {
                Expression keepExpression = inputExpressions.get(1);
                if (keepExpression instanceof ConstantOperand) {
                    outputExpressionLists.add(Collections.singletonList(keepExpression));
                    return;
                }
                if (keepExpression instanceof CompareBinaryExpression) {
                    Expression leftExpression = ((CompareBinaryExpression)keepExpression).getLeftExpression();
                    Expression rightExpression = ((CompareBinaryExpression)keepExpression).getRightExpression();
                    if (leftExpression instanceof TimeSeriesOperand && leftExpression.getExpressionString().equalsIgnoreCase("keep") && rightExpression.isConstantOperand()) {
                        outputExpressionLists.add(Collections.singletonList(ExpressionUtils.reconstructBinaryExpression(keepExpression.getExpressionType(), new TimeSeriesOperand((PartialPath)new MeasurementPath(((TimeSeriesOperand)leftExpression).getPath(), TSDataType.INT64)), rightExpression)));
                        return;
                    }
                    throw new SemanticException(String.format("Please check input keep condition of Aggregation function [%s]", functionName));
                }
                throw new SemanticException(String.format("Keep condition of Aggregation function [%s] need to be constant or compare expression constructed by keep and a long number", functionName));
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation function: " + functionName);
    }

    public static TSDataType getBuiltInFunctionDataType(String funcName, TSDataType dataType) {
        if (funcName == null) {
            throw new IllegalArgumentException("ScalarFunction Name must not be null");
        }
        TypeInferenceUtils.verifyIsBuiltInFunctionDataTypeMatched(funcName, dataType);
        switch (funcName.toLowerCase()) {
            case "diff": {
                return TSDataType.DOUBLE;
            }
        }
        throw new IllegalArgumentException("Invalid Scalar function: " + funcName);
    }

    private static void verifyIsBuiltInFunctionDataTypeMatched(String funcName, TSDataType dataType) {
        if (dataType == null) {
            return;
        }
        switch (funcName.toLowerCase()) {
            case "diff": {
                if (dataType.isNumeric()) {
                    return;
                }
                throw new SemanticException(String.format("Input series of Scalar function [%s] only supports numeric data types [INT32, INT64, FLOAT, DOUBLE]", funcName));
            }
        }
        throw new IllegalArgumentException("Invalid Scalar function: " + funcName);
    }

    public static boolean canAutoCast(TSDataType fromType, TSDataType toType) {
        if (fromType.equals((Object)toType)) {
            return true;
        }
        switch (fromType) {
            case INT32: {
                switch (toType) {
                    case INT64: 
                    case FLOAT: 
                    case DOUBLE: {
                        return true;
                    }
                }
                return false;
            }
            case INT64: 
            case FLOAT: {
                return toType.equals((Object)TSDataType.DOUBLE);
            }
            case DOUBLE: 
            case BOOLEAN: 
            case TEXT: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + fromType);
    }
}

