/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.schedule.task;

import java.util.Objects;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.schedule.queue.ID;
import org.jetbrains.annotations.NotNull;

public class DriverTaskId
implements ID,
Comparable<DriverTaskId> {
    private final FragmentInstanceId fragmentInstanceId;
    private final int pipelineId;
    private final String fullId;

    public DriverTaskId(FragmentInstanceId id, int pipelineId) {
        this.fragmentInstanceId = id;
        this.pipelineId = pipelineId;
        this.fullId = String.format("%s.%d", id.getFullId(), pipelineId);
    }

    public int hashCode() {
        return Objects.hash(this.fragmentInstanceId, this.pipelineId);
    }

    public boolean equals(Object o) {
        return o instanceof DriverTaskId && ((DriverTaskId)o).fragmentInstanceId.equals(this.fragmentInstanceId) && ((DriverTaskId)o).pipelineId == this.pipelineId;
    }

    public String toString() {
        return this.fullId;
    }

    public FragmentInstanceId getFragmentInstanceId() {
        return this.fragmentInstanceId;
    }

    public PlanFragmentId getFragmentId() {
        return this.fragmentInstanceId.getFragmentId();
    }

    public QueryId getQueryId() {
        return this.fragmentInstanceId.getQueryId();
    }

    public int getPipelineId() {
        return this.pipelineId;
    }

    public String getFullId() {
        return this.fullId;
    }

    @Override
    public int compareTo(@NotNull DriverTaskId o) {
        return String.CASE_INSENSITIVE_ORDER.compare(this.toString(), o.toString());
    }
}

