/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.updater;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.basic.EntityTraverser;
import org.apache.iotdb.db.metadata.mtree.traverser.updater.Updater;

public abstract class EntityUpdater
extends EntityTraverser<Void>
implements Updater {
    public EntityUpdater(IMNode startNode, PartialPath path, IMTreeStore store, boolean isPrefixMatch) throws MetadataException {
        super(startNode, path, store, isPrefixMatch);
    }

    protected Void generateResult(IMNode nextMatchedNode) {
        try {
            this.updateEntity(nextMatchedNode.getAsEntityMNode());
        }
        catch (MetadataException e) {
            this.setFailure(e);
        }
        return null;
    }

    @Override
    public void update() throws MetadataException {
        while (super.hasNext()) {
            super.next();
        }
        if (!this.isSuccess()) {
            Throwable e = this.getFailure();
            throw new MetadataException(e.getMessage(), e);
        }
    }

    protected abstract void updateEntity(IEntityMNode var1) throws MetadataException;
}

