/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.cache.dualkeycache.impl;

import java.util.function.Function;
import org.apache.iotdb.db.metadata.cache.dualkeycache.IDualKeyCache;
import org.apache.iotdb.db.metadata.cache.dualkeycache.impl.CacheSizeComputerImpl;
import org.apache.iotdb.db.metadata.cache.dualkeycache.impl.DualKeyCacheImpl;
import org.apache.iotdb.db.metadata.cache.dualkeycache.impl.DualKeyCachePolicy;
import org.apache.iotdb.db.metadata.cache.dualkeycache.impl.LRUCacheEntryManager;

public class DualKeyCacheBuilder<FK, SK, V> {
    private LRUCacheEntryManager<FK, SK, V> cacheEntryManager;
    private long memoryCapacity;
    private Function<FK, Integer> firstKeySizeComputer;
    private Function<SK, Integer> secondKeySizeComputer;
    private Function<V, Integer> valueSizeComputer;

    public IDualKeyCache<FK, SK, V> build() {
        return new DualKeyCacheImpl(this.cacheEntryManager, new CacheSizeComputerImpl<FK, SK, V>(this.firstKeySizeComputer, this.secondKeySizeComputer, this.valueSizeComputer), this.memoryCapacity);
    }

    public DualKeyCacheBuilder<FK, SK, V> cacheEvictionPolicy(DualKeyCachePolicy policy) {
        if (policy == DualKeyCachePolicy.LRU) {
            this.cacheEntryManager = new LRUCacheEntryManager();
            return this;
        }
        throw new IllegalStateException();
    }

    public DualKeyCacheBuilder<FK, SK, V> memoryCapacity(long memoryCapacity) {
        this.memoryCapacity = memoryCapacity;
        return this;
    }

    public DualKeyCacheBuilder<FK, SK, V> firstKeySizeComputer(Function<FK, Integer> computer) {
        this.firstKeySizeComputer = computer;
        return this;
    }

    public DualKeyCacheBuilder<FK, SK, V> secondKeySizeComputer(Function<SK, Integer> computer) {
        this.secondKeySizeComputer = computer;
        return this;
    }

    public DualKeyCacheBuilder<FK, SK, V> valueSizeComputer(Function<V, Integer> computer) {
        this.valueSizeComputer = computer;
        return this;
    }
}

