/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.store;

import java.util.HashMap;
import java.util.Map;

public enum ProcedureType {
    ADD_CONFIG_NODE_PROCEDURE(0),
    REMOVE_CONFIG_NODE_PROCEDURE(1),
    REMOVE_DATA_NODE_PROCEDURE(100),
    DELETE_STORAGE_GROUP_PROCEDURE(200),
    REGION_MIGRATE_PROCEDURE(201),
    CREATE_REGION_GROUPS(202),
    DELETE_TIMESERIES_PROCEDURE(300),
    CREATE_TRIGGER_PROCEDURE(400),
    DROP_TRIGGER_PROCEDURE(401),
    CREATE_PIPE_PROCEDURE(500),
    START_PIPE_PROCEDURE(501),
    STOP_PIPE_PROCEDURE(502),
    DROP_PIPE_PROCEDURE(503),
    CREATE_CQ_PROCEDURE(600),
    DEACTIVATE_TEMPLATE_PROCEDURE(700),
    UNSET_TEMPLATE_PROCEDURE(701),
    CREATE_MODEL_PROCEDURE(800),
    DROP_MODEL_PROCEDURE(801);

    private final short typeCode;
    private static final Map<Short, ProcedureType> TYPE_CODE_MAP;

    private ProcedureType(short typeCode) {
        this.typeCode = typeCode;
    }

    public short getTypeCode() {
        return this.typeCode;
    }

    public static ProcedureType convertToProcedureType(short typeCode) {
        return TYPE_CODE_MAP.getOrDefault(typeCode, null);
    }

    static {
        TYPE_CODE_MAP = new HashMap<Short, ProcedureType>();
        for (ProcedureType procedureType : ProcedureType.values()) {
            TYPE_CODE_MAP.put(procedureType.getTypeCode(), procedureType);
        }
    }
}

