/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.store.IProcedureFactory;
import org.apache.iotdb.confignode.procedure.store.IProcedureStore;
import org.apache.iotdb.confignode.procedure.store.ProcedureWAL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureStore
implements IProcedureStore {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureStore.class);
    private String procedureWalDir = CommonDescriptor.getInstance().getConfig().getProcedureWalFolder();
    private final ConcurrentHashMap<Long, ProcedureWAL> procWALMap = new ConcurrentHashMap();
    public static final String PROCEDURE_WAL_SUFFIX = ".proc.wal";
    private final IProcedureFactory procedureFactory;
    private volatile boolean isRunning = false;

    public ProcedureStore(IProcedureFactory procedureFactory) {
        try {
            this.procedureFactory = procedureFactory;
            Files.createDirectories(Paths.get(this.procedureWalDir, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Create procedure wal directory failed.", e);
        }
    }

    public ProcedureStore(String testWALDir, IProcedureFactory procedureFactory) {
        this.procedureFactory = procedureFactory;
        try {
            Files.createDirectories(Paths.get(testWALDir, new String[0]), new FileAttribute[0]);
            this.procedureWalDir = testWALDir;
        }
        catch (IOException e) {
            throw new RuntimeException("Create procedure wal directory failed.", e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void setRunning(boolean running) {
        this.isRunning = running;
    }

    @Override
    public void load(List<Procedure> procedureList) {
        try (Stream<Path> s = Files.list(Paths.get(this.procedureWalDir, new String[0]));){
            s.filter(path -> path.getFileName().toString().endsWith(PROCEDURE_WAL_SUFFIX)).sorted((p1, p2) -> Long.compareUnsigned(Long.parseLong(p1.getFileName().toString().split("\\.")[0]), Long.parseLong(p2.getFileName().toString().split("\\.")[0]))).forEach(path -> {
                String fileName = path.getFileName().toString();
                long procId = Long.parseLong(fileName.split("\\.")[0]);
                ProcedureWAL procedureWAL = this.procWALMap.computeIfAbsent(procId, id -> new ProcedureWAL((Path)path, this.procedureFactory));
                procedureWAL.load(procedureList);
            });
        }
        catch (IOException e) {
            LOG.error("Load procedure wal failed.", (Throwable)e);
        }
    }

    @Override
    public void update(Procedure procedure) {
        if (!procedure.needPersistance()) {
            this.procWALMap.remove(procedure.getProcId());
            return;
        }
        long procId = procedure.getProcId();
        Path path = Paths.get(this.procedureWalDir, procId + PROCEDURE_WAL_SUFFIX);
        ProcedureWAL procedureWAL = this.procWALMap.computeIfAbsent(procId, id -> new ProcedureWAL(path, this.procedureFactory));
        try {
            procedureWAL.save(procedure);
        }
        catch (IOException e) {
            LOG.error("Update Procedure (pid={}) wal failed", (Object)procedure.getProcId());
        }
    }

    @Override
    public void update(Procedure[] subprocs) {
        for (Procedure subproc : subprocs) {
            this.update(subproc);
        }
    }

    @Override
    public void delete(long procId) {
        ProcedureWAL procedureWAL = this.procWALMap.get(procId);
        if (procedureWAL != null) {
            procedureWAL.delete();
        }
        this.procWALMap.remove(procId);
    }

    @Override
    public void delete(long[] childProcIds) {
        for (long childProcId : childProcIds) {
            this.delete(childProcId);
        }
    }

    @Override
    public void delete(long[] batchIds, int startIndex, int batchCount) {
        for (int i = startIndex; i < batchCount; ++i) {
            this.delete(batchIds[i]);
        }
    }

    @Override
    public void cleanup() {
        try {
            FileUtils.cleanDirectory((File)new File(this.procedureWalDir));
        }
        catch (IOException e) {
            LOG.error("Clean wal directory failed", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        this.isRunning = false;
    }

    @Override
    public void start() {
        if (!this.isRunning) {
            this.isRunning = true;
        }
    }
}

