/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeRegionGroupUtil;
import org.apache.iotdb.rpc.TSStatusCode;

abstract class DataNodeRegionTask<T> {
    protected final ConfigNodeProcedureEnv env;
    protected final Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup;
    protected final boolean executeOnAllReplicaset;
    private final Map<Integer, List<T>> responseMap = new ConcurrentHashMap<Integer, List<T>>();

    protected DataNodeRegionTask(ConfigNodeProcedureEnv env, Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup, boolean executeOnAllReplicaset) {
        this.env = env;
        this.targetSchemaRegionGroup = targetSchemaRegionGroup;
        this.executeOnAllReplicaset = executeOnAllReplicaset;
    }

    void execute() {
        Map<TDataNodeLocation, List<TConsensusGroupId>> dataNodeConsensusGroupIdMap;
        HashSet<TDataNodeLocation> allFailedDataNodeSet = new HashSet<TDataNodeLocation>();
        Map<TDataNodeLocation, List<TConsensusGroupId>> map = dataNodeConsensusGroupIdMap = this.executeOnAllReplicaset ? DataNodeRegionGroupUtil.getAllReplicaDataNodeRegionGroupMap(this.targetSchemaRegionGroup) : DataNodeRegionGroupUtil.getLeaderDataNodeRegionGroupMap(this.env.getConfigManager().getLoadManager().getLatestRegionLeaderMap(), this.targetSchemaRegionGroup);
        while (!dataNodeConsensusGroupIdMap.isEmpty()) {
            Map<TDataNodeLocation, List<TConsensusGroupId>> currentFailedDataNodeMap = this.sendRegionRequest(dataNodeConsensusGroupIdMap);
            if (this.hasFailure()) {
                return;
            }
            if (currentFailedDataNodeMap.isEmpty()) break;
            currentFailedDataNodeMap.forEach(dataNodeConsensusGroupIdMap::remove);
            allFailedDataNodeSet.removeAll(dataNodeConsensusGroupIdMap.keySet());
            dataNodeConsensusGroupIdMap = this.getAvailableDataNodeLocationForRetry(currentFailedDataNodeMap, allFailedDataNodeSet);
            if (!this.hasFailure()) continue;
            return;
        }
    }

    private Map<TDataNodeLocation, List<TConsensusGroupId>> sendRegionRequest(Map<TDataNodeLocation, List<TConsensusGroupId>> dataNodeConsensusGroupIdMap) {
        HashMap<TDataNodeLocation, List<TConsensusGroupId>> failedDataNodeMap = new HashMap<TDataNodeLocation, List<TConsensusGroupId>>();
        for (Map.Entry<TDataNodeLocation, List<TConsensusGroupId>> entry : dataNodeConsensusGroupIdMap.entrySet()) {
            Map<Integer, TSStatus> dataNodeResponseMap = this.sendRequest(entry.getKey(), entry.getValue());
            TSStatus currentDataNodeResponse = dataNodeResponseMap.get(entry.getKey().getDataNodeId());
            if (currentDataNodeResponse.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            if (currentDataNodeResponse.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                this.onExecutionFailure(entry.getKey());
                break;
            }
            failedDataNodeMap.put(entry.getKey(), entry.getValue());
        }
        return failedDataNodeMap;
    }

    private Map<TDataNodeLocation, List<TConsensusGroupId>> getAvailableDataNodeLocationForRetry(Map<TDataNodeLocation, List<TConsensusGroupId>> failedDataNodeConsensusGroupIdMap, Set<TDataNodeLocation> allFailedDataNodeSet) {
        Map<TConsensusGroupId, Integer> leaderMap = this.env.getConfigManager().getLoadManager().getLatestRegionLeaderMap();
        HashMap<TDataNodeLocation, List<TConsensusGroupId>> availableDataNodeLocation = new HashMap<TDataNodeLocation, List<TConsensusGroupId>>();
        for (List<TConsensusGroupId> consensusGroupIdList : failedDataNodeConsensusGroupIdMap.values()) {
            for (TConsensusGroupId consensusGroupId : consensusGroupIdList) {
                TRegionReplicaSet regionReplicaSet = this.targetSchemaRegionGroup.get(consensusGroupId);
                TDataNodeLocation selectedDataNode = null;
                Integer leaderId = leaderMap.get(consensusGroupId);
                if (leaderId == null || leaderId == -1) {
                    for (TDataNodeLocation candidateDataNode : regionReplicaSet.getDataNodeLocations()) {
                        if (allFailedDataNodeSet.contains(candidateDataNode)) continue;
                        selectedDataNode = candidateDataNode;
                        break;
                    }
                } else {
                    for (TDataNodeLocation candidateDataNode : regionReplicaSet.getDataNodeLocations()) {
                        if (allFailedDataNodeSet.contains(candidateDataNode)) continue;
                        if (leaderId.intValue() == candidateDataNode.getDataNodeId()) {
                            selectedDataNode = candidateDataNode;
                            break;
                        }
                        if (selectedDataNode != null) continue;
                        selectedDataNode = candidateDataNode;
                    }
                }
                if (selectedDataNode == null) {
                    this.onAllReplicasetFailure(consensusGroupId);
                    return availableDataNodeLocation;
                }
                availableDataNodeLocation.computeIfAbsent(selectedDataNode, k -> new ArrayList()).add(consensusGroupId);
            }
        }
        return availableDataNodeLocation;
    }

    protected void saveDataNodeResponse(Integer dataNodeId, T response) {
        this.responseMap.computeIfAbsent(dataNodeId, k -> new ArrayList()).add(response);
    }

    Map<Integer, List<T>> getResponseMap() {
        return this.responseMap;
    }

    protected abstract Map<Integer, TSStatus> sendRequest(TDataNodeLocation var1, List<TConsensusGroupId> var2);

    protected abstract boolean hasFailure();

    protected abstract void onExecutionFailure(TDataNodeLocation var1);

    protected abstract void onAllReplicasetFailure(TConsensusGroupId var1);
}

