/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.sync;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.exception.sync.PipeNotExistException;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.exception.sync.PipeSinkNotExistException;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.sync.metadata.SyncMetadata;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.confignode.consensus.request.write.sync.CreatePipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.DropPipePlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.DropPipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.GetPipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.PreCreatePipePlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.RecordPipeMessagePlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.SetPipeStatusPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.ShowPipePlan;
import org.apache.iotdb.confignode.consensus.response.pipe.PipeResp;
import org.apache.iotdb.confignode.consensus.response.pipe.PipeSinkResp;
import org.apache.iotdb.confignode.rpc.thrift.TPipeSinkInfo;
import org.apache.iotdb.db.utils.sync.SyncPipeUtil;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSyncInfo
implements SnapshotProcessor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ClusterSyncInfo.class);
    private final SyncMetadata syncMetadata;
    private final ReentrantLock syncMetadataLock = new ReentrantLock();

    public ClusterSyncInfo() {
        this.syncMetadata = new SyncMetadata();
    }

    public void checkAddPipeSink(CreatePipeSinkPlan createPipeSinkPlan) throws PipeSinkException {
        this.syncMetadata.checkPipeSinkNoExist(createPipeSinkPlan.getPipeSinkInfo().getPipeSinkName());
        SyncPipeUtil.parseTPipeSinkInfoAsPipeSink((TPipeSinkInfo)createPipeSinkPlan.getPipeSinkInfo());
    }

    public TSStatus addPipeSink(CreatePipeSinkPlan plan) {
        TSStatus status = new TSStatus();
        try {
            this.syncMetadata.addPipeSink(SyncPipeUtil.parseTPipeSinkInfoAsPipeSink((TPipeSinkInfo)plan.getPipeSinkInfo()));
            status.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (PipeSinkException e) {
            LOGGER.error("failed to execute CreatePipeSinkPlan {} on ClusterSyncInfo", (Object)plan, (Object)e);
            status.setCode(TSStatusCode.CREATE_PIPE_SINK_ERROR.getStatusCode());
            LOGGER.error(e.getMessage());
        }
        return status;
    }

    public void checkDropPipeSink(String pipeSinkName) throws PipeSinkException {
        this.syncMetadata.checkDropPipeSink(pipeSinkName);
    }

    public TSStatus dropPipeSink(DropPipeSinkPlan plan) {
        this.syncMetadata.dropPipeSink(plan.getPipeSinkName());
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public PipeSinkResp getPipeSink(GetPipeSinkPlan plan) {
        PipeSinkResp resp = new PipeSinkResp();
        if (StringUtils.isEmpty((CharSequence)plan.getPipeSinkName())) {
            resp.setPipeSinkList(this.syncMetadata.getAllPipeSink());
        } else {
            resp.setPipeSinkList(Collections.singletonList(this.syncMetadata.getPipeSink(plan.getPipeSinkName())));
        }
        resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return resp;
    }

    public void checkAddPipe(PipeInfo pipeInfo) throws PipeException, PipeSinkNotExistException {
        this.syncMetadata.checkAddPipe(pipeInfo);
    }

    public TSStatus preCreatePipe(PreCreatePipePlan physicalPlan) {
        this.syncMetadata.addPipe(physicalPlan.getPipeInfo());
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus setPipeStatus(SetPipeStatusPlan physicalPlan) {
        this.syncMetadata.setPipeStatus(physicalPlan.getPipeName(), physicalPlan.getPipeStatus());
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus dropPipe(DropPipePlan physicalPlan) {
        this.syncMetadata.dropPipe(physicalPlan.getPipeName());
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus recordPipeMessage(RecordPipeMessagePlan physicalPlan) {
        this.syncMetadata.changePipeMessage(physicalPlan.getPipeName(), physicalPlan.getPipeMessage().getType());
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public PipeResp showPipe(ShowPipePlan plan) {
        PipeResp resp = new PipeResp();
        if (StringUtils.isEmpty((CharSequence)plan.getPipeName())) {
            resp.setPipeInfoList(this.syncMetadata.getAllPipeInfos());
        } else {
            resp.setPipeInfoList(Collections.singletonList(this.syncMetadata.getPipeInfo(plan.getPipeName())));
        }
        resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return resp;
    }

    public PipeInfo getPipeInfo(String pipeName) throws PipeNotExistException {
        PipeInfo pipeInfo = this.syncMetadata.getPipeInfo(pipeName);
        if (pipeInfo == null) {
            throw new PipeNotExistException(pipeName);
        }
        return pipeInfo;
    }

    public List<PipeInfo> getAllPipeInfos() {
        return this.syncMetadata.getAllPipeInfos();
    }

    public void lockSyncMetadata() {
        LOGGER.info("Lock SyncMetadata");
        this.syncMetadataLock.lock();
        LOGGER.info("Acquire SyncMetadata lock");
    }

    public void unlockSyncMetadata() {
        LOGGER.info("Unlock SyncMetadata");
        this.syncMetadataLock.unlock();
    }

    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        return this.syncMetadata.processTakeSnapshot(snapshotDir);
    }

    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        this.syncMetadata.processLoadSnapshot(snapshotDir);
    }
}

