/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.partition.heartbeat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.partition.RegionGroupStatus;
import org.apache.iotdb.confignode.manager.partition.heartbeat.RegionStatistics;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class RegionGroupStatistics {
    private RegionGroupStatus regionGroupStatus;
    private final Map<Integer, RegionStatistics> regionStatisticsMap;

    public RegionGroupStatistics() {
        this.regionStatisticsMap = new ConcurrentHashMap<Integer, RegionStatistics>();
    }

    public RegionGroupStatistics(RegionGroupStatus regionGroupStatus, Map<Integer, RegionStatistics> regionStatisticsMap) {
        this.regionGroupStatus = regionGroupStatus;
        this.regionStatisticsMap = regionStatisticsMap;
    }

    public RegionGroupStatus getRegionGroupStatus() {
        return this.regionGroupStatus;
    }

    public RegionStatus getRegionStatus(int dataNodeId) {
        return this.regionStatisticsMap.containsKey(dataNodeId) ? this.regionStatisticsMap.get(dataNodeId).getRegionStatus() : RegionStatus.Unknown;
    }

    public Map<Integer, RegionStatistics> getRegionStatisticsMap() {
        return this.regionStatisticsMap;
    }

    public static RegionGroupStatistics generateDefaultRegionGroupStatistics() {
        return new RegionGroupStatistics(RegionGroupStatus.Disabled, new ConcurrentHashMap<Integer, RegionStatistics>());
    }

    public RegionGroupStatistics deepCopy() {
        ConcurrentHashMap<Integer, RegionStatistics> deepCopyMap = new ConcurrentHashMap<Integer, RegionStatistics>();
        this.regionStatisticsMap.forEach((dataNodeId, regionStatistics) -> deepCopyMap.put((Integer)dataNodeId, regionStatistics.deepCopy()));
        return new RegionGroupStatistics(this.regionGroupStatus, deepCopyMap);
    }

    public void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.regionGroupStatus.getStatus(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.regionStatisticsMap.size(), (OutputStream)stream);
        for (Map.Entry<Integer, RegionStatistics> regionStatisticsEntry : this.regionStatisticsMap.entrySet()) {
            ReadWriteIOUtils.write((int)regionStatisticsEntry.getKey(), (OutputStream)stream);
            regionStatisticsEntry.getValue().serialize(stream);
        }
    }

    public void deserialize(InputStream inputStream) throws IOException {
        this.regionGroupStatus = RegionGroupStatus.parse(ReadWriteIOUtils.readString((InputStream)inputStream));
        int regionNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < regionNum; ++i) {
            int belongedDataNodeId = ReadWriteIOUtils.readInt((InputStream)inputStream);
            RegionStatistics regionStatistics = new RegionStatistics();
            regionStatistics.deserialize(inputStream);
            this.regionStatisticsMap.put(belongedDataNodeId, regionStatistics);
        }
    }

    public void deserialize(ByteBuffer buffer) {
        this.regionGroupStatus = RegionGroupStatus.parse(ReadWriteIOUtils.readString((ByteBuffer)buffer));
        int regionNum = buffer.getInt();
        for (int i = 0; i < regionNum; ++i) {
            int belongedDataNodeId = buffer.getInt();
            RegionStatistics regionStatistics = new RegionStatistics();
            regionStatistics.deserialize(buffer);
            this.regionStatisticsMap.put(belongedDataNodeId, regionStatistics);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionGroupStatistics that = (RegionGroupStatistics)o;
        return this.regionGroupStatus == that.regionGroupStatus && this.regionStatisticsMap.equals(that.regionStatisticsMap);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.regionGroupStatus, this.regionStatisticsMap});
    }

    public String toString() {
        return "RegionGroupStatistics{regionGroupStatus=" + (Object)((Object)this.regionGroupStatus) + '}';
    }
}

