/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.router.priority;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.router.priority.GreedyPriorityBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.priority.IPriorityBalancer;

public class LeaderPriorityBalancer
extends GreedyPriorityBalancer
implements IPriorityBalancer {
    @Override
    public Map<TConsensusGroupId, TRegionReplicaSet> generateOptimalRoutePriority(List<TRegionReplicaSet> replicaSets, Map<TConsensusGroupId, Integer> regionLeaderMap, Map<Integer, Long> dataNodeLoadScoreMap) {
        ConcurrentHashMap<TConsensusGroupId, TRegionReplicaSet> regionPriorityMap = new ConcurrentHashMap<TConsensusGroupId, TRegionReplicaSet>();
        replicaSets.forEach(replicaSet -> {
            TRegionReplicaSet sortedReplicaSet = LeaderPriorityBalancer.sortReplicasByLoadScore(replicaSet, dataNodeLoadScoreMap);
            int leaderId = regionLeaderMap.getOrDefault(replicaSet.getRegionId(), -1);
            if (leaderId != -1 && dataNodeLoadScoreMap.getOrDefault(leaderId, Long.MAX_VALUE) < Long.MAX_VALUE) {
                for (int i = 0; i < sortedReplicaSet.getDataNodeLocationsSize(); ++i) {
                    if (((TDataNodeLocation)sortedReplicaSet.getDataNodeLocations().get(i)).getDataNodeId() != leaderId) continue;
                    Collections.swap(sortedReplicaSet.getDataNodeLocations(), 0, i);
                    break;
                }
            }
            regionPriorityMap.put(sortedReplicaSet.getRegionId(), sortedReplicaSet);
        });
        return regionPriorityMap;
    }
}

