/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.router;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class RegionRouteMap {
    private Map<TConsensusGroupId, Integer> regionLeaderMap = new ConcurrentHashMap<TConsensusGroupId, Integer>();
    private Map<TConsensusGroupId, TRegionReplicaSet> regionPriorityMap = new ConcurrentHashMap<TConsensusGroupId, TRegionReplicaSet>();

    public int getLeader(TConsensusGroupId regionGroupId) {
        return this.regionLeaderMap.getOrDefault(regionGroupId, -1);
    }

    public void setLeader(TConsensusGroupId regionGroupId, int leaderId) {
        this.regionLeaderMap.put(regionGroupId, leaderId);
    }

    public Map<TConsensusGroupId, Integer> getRegionLeaderMap() {
        return this.regionLeaderMap;
    }

    public void setRegionLeaderMap(Map<TConsensusGroupId, Integer> regionLeaderMap) {
        this.regionLeaderMap = regionLeaderMap;
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getRegionPriorityMap() {
        return this.regionPriorityMap;
    }

    public boolean isEmpty() {
        return this.regionLeaderMap.isEmpty() && this.regionPriorityMap.isEmpty();
    }

    public void setRegionPriorityMap(Map<TConsensusGroupId, TRegionReplicaSet> regionPriorityMap) {
        this.regionPriorityMap = regionPriorityMap;
    }

    public void removeRegionRouteCache(TConsensusGroupId regionGroupId) {
        this.regionLeaderMap.remove(regionGroupId);
        this.regionPriorityMap.remove(regionGroupId);
    }

    public void serialize(OutputStream stream, TProtocol protocol) throws IOException {
        try {
            ReadWriteIOUtils.write((int)this.regionLeaderMap.size(), (OutputStream)stream);
            for (Map.Entry<TConsensusGroupId, Integer> entry : this.regionLeaderMap.entrySet()) {
                entry.getKey().write(protocol);
                ReadWriteIOUtils.write((int)entry.getValue(), (OutputStream)stream);
            }
            ReadWriteIOUtils.write((int)this.regionPriorityMap.size(), (OutputStream)stream);
            for (Map.Entry<TConsensusGroupId, Integer> entry : this.regionPriorityMap.entrySet()) {
                entry.getKey().write(protocol);
                ((TRegionReplicaSet)entry.getValue()).write(protocol);
            }
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public void deserialize(ByteBuffer buffer) {
        this.regionLeaderMap = new ConcurrentHashMap<TConsensusGroupId, Integer>();
        int leaderEntryNum = buffer.getInt();
        for (int i = 0; i < leaderEntryNum; ++i) {
            TConsensusGroupId regionGroupId = ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)buffer);
            int leaderId = buffer.getInt();
            this.regionLeaderMap.put(regionGroupId, leaderId);
        }
        this.regionPriorityMap = new ConcurrentHashMap<TConsensusGroupId, TRegionReplicaSet>();
        int priorityEntryNum = buffer.getInt();
        for (int i = 0; i < priorityEntryNum; ++i) {
            TConsensusGroupId regionGroupId = ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)buffer);
            TRegionReplicaSet regionReplicaSet = ThriftCommonsSerDeUtils.deserializeTRegionReplicaSet((ByteBuffer)buffer);
            this.regionPriorityMap.put(regionGroupId, regionReplicaSet);
        }
    }

    public void deserialize(InputStream stream, TProtocol protocol) throws IOException, TException {
        this.regionLeaderMap = new ConcurrentHashMap<TConsensusGroupId, Integer>();
        int leaderEntryNum = ReadWriteIOUtils.readInt((InputStream)stream);
        for (int i = 0; i < leaderEntryNum; ++i) {
            TConsensusGroupId regionGroupId = new TConsensusGroupId();
            regionGroupId.read(protocol);
            int leaderId = ReadWriteIOUtils.readInt((InputStream)stream);
            this.regionLeaderMap.put(regionGroupId, leaderId);
        }
        this.regionPriorityMap = new ConcurrentHashMap<TConsensusGroupId, TRegionReplicaSet>();
        int priorityEntryNum = ReadWriteIOUtils.readInt((InputStream)stream);
        for (int i = 0; i < priorityEntryNum; ++i) {
            TConsensusGroupId regionGroupId = new TConsensusGroupId();
            regionGroupId.read(protocol);
            TRegionReplicaSet regionReplicaSet = new TRegionReplicaSet();
            regionReplicaSet.read(protocol);
            this.regionPriorityMap.put(regionGroupId, regionReplicaSet);
        }
    }

    public void clear() {
        this.regionLeaderMap.clear();
        this.regionPriorityMap.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionRouteMap that = (RegionRouteMap)o;
        return this.regionLeaderMap.equals(that.regionLeaderMap) && this.regionPriorityMap.equals(that.regionPriorityMap);
    }

    public int hashCode() {
        return Objects.hash(this.regionLeaderMap, this.regionPriorityMap);
    }
}

