/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.exception.NotEnoughDataNodeException;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.balancer.region.CopySetRegionGroupAllocator;
import org.apache.iotdb.confignode.manager.load.balancer.region.GreedyRegionGroupAllocator;
import org.apache.iotdb.confignode.manager.load.balancer.region.IRegionGroupAllocator;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.manager.schema.ClusterSchemaManager;

public class RegionBalancer {
    private final IManager configManager;
    private final IRegionGroupAllocator regionGroupAllocator;

    public RegionBalancer(IManager configManager) {
        this.configManager = configManager;
        switch (ConfigNodeDescriptor.getInstance().getConf().getRegionGroupAllocatePolicy()) {
            case COPY_SET: {
                this.regionGroupAllocator = new CopySetRegionGroupAllocator();
                break;
            }
            default: {
                this.regionGroupAllocator = new GreedyRegionGroupAllocator();
            }
        }
    }

    public CreateRegionGroupsPlan genRegionGroupsAllocationPlan(Map<String, Integer> allotmentMap, TConsensusGroupType consensusGroupType) throws NotEnoughDataNodeException, DatabaseNotExistsException {
        List<TDataNodeConfiguration> onlineDataNodes = this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running);
        List<TDataNodeConfiguration> availableDataNodes = this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running, NodeStatus.Unknown);
        for (String storageGroup : allotmentMap.keySet()) {
            int replicationFactor = this.getClusterSchemaManager().getReplicationFactor(storageGroup, consensusGroupType);
            if (availableDataNodes.size() >= replicationFactor) continue;
            throw new NotEnoughDataNodeException();
        }
        CreateRegionGroupsPlan createRegionGroupsPlan = new CreateRegionGroupsPlan();
        List<TRegionReplicaSet> allocatedRegionGroups = this.getPartitionManager().getAllReplicaSets(consensusGroupType);
        for (Map.Entry<String, Integer> entry : allotmentMap.entrySet()) {
            String storageGroup = entry.getKey();
            int allotment = entry.getValue();
            int replicationFactor = this.getClusterSchemaManager().getReplicationFactor(storageGroup, consensusGroupType);
            List<TDataNodeConfiguration> targetDataNodes = onlineDataNodes.size() >= replicationFactor ? onlineDataNodes : availableDataNodes;
            for (int i = 0; i < allotment; ++i) {
                ConcurrentHashMap<Integer, TDataNodeConfiguration> availableDataNodeMap = new ConcurrentHashMap<Integer, TDataNodeConfiguration>();
                ConcurrentHashMap<Integer, Double> freeDiskSpaceMap = new ConcurrentHashMap<Integer, Double>();
                targetDataNodes.forEach(dataNodeConfiguration -> {
                    int dataNodeId = dataNodeConfiguration.getLocation().getDataNodeId();
                    availableDataNodeMap.put(dataNodeId, (TDataNodeConfiguration)dataNodeConfiguration);
                    freeDiskSpaceMap.put(dataNodeId, this.getNodeManager().getFreeDiskSpace(dataNodeId));
                });
                TRegionReplicaSet newRegionGroup = this.regionGroupAllocator.generateOptimalRegionReplicasDistribution(availableDataNodeMap, freeDiskSpaceMap, allocatedRegionGroups, replicationFactor, new TConsensusGroupId(consensusGroupType, this.getPartitionManager().generateNextRegionGroupId()));
                createRegionGroupsPlan.addRegionGroup(storageGroup, newRegionGroup);
                allocatedRegionGroups.add(newRegionGroup);
            }
        }
        return createRegionGroupsPlan;
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    public static enum RegionGroupAllocatePolicy {
        COPY_SET,
        GREEDY;

    }
}

