/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer;

import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.confignode.exception.NoAvailableRegionGroupException;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.balancer.partition.GreedyPartitionAllocator;
import org.apache.iotdb.confignode.manager.load.balancer.partition.IPartitionAllocator;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;

public class PartitionBalancer {
    private final IManager configManager;

    public PartitionBalancer(IManager configManager) {
        this.configManager = configManager;
    }

    public Map<String, SchemaPartitionTable> allocateSchemaPartition(Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlotsMap) throws NoAvailableRegionGroupException {
        return this.genPartitionAllocator().allocateSchemaPartition(unassignedSchemaPartitionSlotsMap);
    }

    public Map<String, DataPartitionTable> allocateDataPartition(Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> unassignedDataPartitionSlotsMap) throws NoAvailableRegionGroupException {
        return this.genPartitionAllocator().allocateDataPartition(unassignedDataPartitionSlotsMap);
    }

    private IPartitionAllocator genPartitionAllocator() {
        return new GreedyPartitionAllocator(this.configManager);
    }
}

