/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.region;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class GetRegionIdPlan
extends ConfigPhysicalPlan {
    private String storageGroup;
    private TConsensusGroupType partitionType;
    private TSeriesPartitionSlot seriesSlotId;
    private TTimePartitionSlot timeSlotId;

    public GetRegionIdPlan() {
        super(ConfigPhysicalPlanType.GetRegionId);
    }

    public GetRegionIdPlan(String storageGroup, TConsensusGroupType partitionType, TSeriesPartitionSlot seriesSlotId, TTimePartitionSlot timeSlotId) {
        this();
        this.partitionType = partitionType;
        this.storageGroup = storageGroup;
        this.timeSlotId = timeSlotId;
        this.seriesSlotId = seriesSlotId;
    }

    public String getDatabase() {
        return this.storageGroup;
    }

    public TConsensusGroupType getPartitionType() {
        return this.partitionType;
    }

    public TSeriesPartitionSlot getSeriesSlotId() {
        return this.seriesSlotId;
    }

    public TTimePartitionSlot getTimeSlotId() {
        return this.timeSlotId;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.storageGroup, (OutputStream)stream);
        stream.writeInt(this.partitionType.ordinal());
        ThriftCommonsSerDeUtils.serializeTSeriesPartitionSlot((TSeriesPartitionSlot)this.seriesSlotId, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTTimePartitionSlot((TTimePartitionSlot)this.timeSlotId, (DataOutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.storageGroup = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.partitionType = TConsensusGroupType.findByValue((int)buffer.getInt());
        this.seriesSlotId = ThriftCommonsSerDeUtils.deserializeTSeriesPartitionSlot((ByteBuffer)buffer);
        this.timeSlotId = ThriftCommonsSerDeUtils.deserializeTTimePartitionSlot((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetRegionIdPlan that = (GetRegionIdPlan)o;
        return this.storageGroup.equals(that.storageGroup) && this.seriesSlotId.equals(that.seriesSlotId) && this.timeSlotId.equals(that.timeSlotId);
    }

    @Override
    public int hashCode() {
        int hashcode = 1;
        hashcode = hashcode * 31 + Objects.hash(this.storageGroup);
        hashcode = hashcode * 31 + this.seriesSlotId.hashCode();
        hashcode = hashcode * 31 + this.timeSlotId.hashCode();
        return hashcode;
    }
}

