/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.partition;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class GetTimeSlotListPlan
extends ConfigPhysicalPlan {
    private String storageGroup;
    private TSeriesPartitionSlot seriesSlotId;
    private long startTime;
    private long endTime;

    public GetTimeSlotListPlan() {
        super(ConfigPhysicalPlanType.GetTimeSlotList);
    }

    public GetTimeSlotListPlan(String storageGroup, TSeriesPartitionSlot seriesSlotId, long startTime, long endTime) {
        this();
        this.storageGroup = storageGroup;
        this.seriesSlotId = seriesSlotId;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public String getDatabase() {
        return this.storageGroup;
    }

    public TSeriesPartitionSlot getSeriesSlotId() {
        return this.seriesSlotId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.storageGroup, (OutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTSeriesPartitionSlot((TSeriesPartitionSlot)this.seriesSlotId, (DataOutputStream)stream);
        stream.writeLong(this.startTime);
        stream.writeLong(this.endTime);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.storageGroup = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.seriesSlotId = ThriftCommonsSerDeUtils.deserializeTSeriesPartitionSlot((ByteBuffer)buffer);
        this.startTime = buffer.getLong();
        this.endTime = buffer.getLong();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTimeSlotListPlan that = (GetTimeSlotListPlan)o;
        return this.storageGroup.equals(that.storageGroup) && this.seriesSlotId.equals(that.seriesSlotId) && this.startTime == that.startTime && this.endTime == that.endTime;
    }

    @Override
    public int hashCode() {
        int hashcode = 1;
        hashcode = hashcode * 31 + Objects.hash(this.storageGroup);
        hashcode = hashcode * 31 + this.seriesSlotId.hashCode();
        hashcode = hashcode * 31 + (int)this.startTime;
        hashcode = hashcode * 31 + (int)this.endTime;
        return hashcode;
    }
}

