/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async;

import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.AsyncTSStatusRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.CountPathsUsingTemplateRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.DeleteSchemaRPCHandler;
import org.apache.iotdb.confignode.client.async.handlers.rpc.FetchSchemaBlackListRPCHandler;
import org.apache.iotdb.mpp.rpc.thrift.TActiveTriggerInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TConstructSchemaBlackListReq;
import org.apache.iotdb.mpp.rpc.thrift.TConstructSchemaBlackListWithTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TCountPathsUsingTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateDataRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateFunctionInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreatePipeOnDataNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateSchemaRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateTriggerInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TDeactivateTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TDeleteDataForDeleteSchemaReq;
import org.apache.iotdb.mpp.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.mpp.rpc.thrift.TDropFunctionInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TDropTriggerInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TFetchSchemaBlackListReq;
import org.apache.iotdb.mpp.rpc.thrift.TInactiveTriggerInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateMatchedSchemaCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TOperatePipeOnDataNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TRegionLeaderChangeReq;
import org.apache.iotdb.mpp.rpc.thrift.TRegionRouteReq;
import org.apache.iotdb.mpp.rpc.thrift.TRollbackSchemaBlackListReq;
import org.apache.iotdb.mpp.rpc.thrift.TRollbackSchemaBlackListWithTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateConfigNodeGroupReq;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateTriggerLocationReq;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDataNodeClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncDataNodeClientPool.class);
    private final IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.AsyncDataNodeInternalServiceClientPoolFactory());
    private static final int MAX_RETRY_NUM = 6;

    private AsyncDataNodeClientPool() {
    }

    public void sendAsyncRequestToDataNodeWithRetry(AsyncClientHandler<?, ?> clientHandler) {
        this.sendAsyncRequest(clientHandler, 6);
    }

    public void sendAsyncRequestToDataNodeWithRetry(AsyncClientHandler<?, ?> clientHandler, int retryNum) {
        this.sendAsyncRequest(clientHandler, retryNum);
    }

    private void sendAsyncRequest(AsyncClientHandler<?, ?> clientHandler, int retryNum) {
        if (clientHandler.getRequestIndices().isEmpty()) {
            return;
        }
        DataNodeRequestType requestType = clientHandler.getRequestType();
        for (int retry = 0; retry < retryNum; ++retry) {
            clientHandler.resetCountDownLatch();
            for (int requestId : clientHandler.getRequestIndices()) {
                TDataNodeLocation targetDataNode = clientHandler.getDataNodeLocation(requestId);
                this.sendAsyncRequestToDataNode(clientHandler, requestId, targetDataNode, retry);
            }
            try {
                clientHandler.getCountDownLatch().await();
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted during {} on ConfigNode", (Object)requestType);
                Thread.currentThread().interrupt();
            }
            if (!clientHandler.getRequestIndices().isEmpty()) continue;
            return;
        }
    }

    private void sendAsyncRequestToDataNode(AsyncClientHandler<?, ?> clientHandler, int requestId, TDataNodeLocation targetDataNode, int retryCount) {
        try {
            AsyncDataNodeInternalServiceClient client = (AsyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)targetDataNode.getInternalEndPoint());
            switch (clientHandler.getRequestType()) {
                case SET_TTL: {
                    client.setTTL((TSetTTLReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case CREATE_DATA_REGION: {
                    client.createDataRegion((TCreateDataRegionReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case DELETE_REGION: {
                    client.deleteRegion((TConsensusGroupId)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case CREATE_SCHEMA_REGION: {
                    client.createSchemaRegion((TCreateSchemaRegionReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case CREATE_FUNCTION: {
                    client.createFunction((TCreateFunctionInstanceReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case DROP_FUNCTION: {
                    client.dropFunction((TDropFunctionInstanceReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case CREATE_TRIGGER_INSTANCE: {
                    client.createTriggerInstance((TCreateTriggerInstanceReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case DROP_TRIGGER_INSTANCE: {
                    client.dropTriggerInstance((TDropTriggerInstanceReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case ACTIVE_TRIGGER_INSTANCE: {
                    client.activeTriggerInstance((TActiveTriggerInstanceReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case INACTIVE_TRIGGER_INSTANCE: {
                    client.inactiveTriggerInstance((TInactiveTriggerInstanceReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case UPDATE_TRIGGER_LOCATION: {
                    client.updateTriggerLocation((TUpdateTriggerLocationReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case MERGE: 
                case FULL_MERGE: {
                    client.merge((AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case FLUSH: {
                    client.flush((TFlushReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case CLEAR_CACHE: {
                    client.clearCache((AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case LOAD_CONFIGURATION: {
                    client.loadConfiguration((AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case SET_SYSTEM_STATUS: {
                    client.setSystemStatus((String)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case UPDATE_REGION_ROUTE_MAP: {
                    client.updateRegionCache((TRegionRouteReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case CHANGE_REGION_LEADER: {
                    client.changeRegionLeader((TRegionLeaderChangeReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case BROADCAST_LATEST_CONFIG_NODE_GROUP: {
                    client.updateConfigNodeGroup((TUpdateConfigNodeGroupReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case CONSTRUCT_SCHEMA_BLACK_LIST: {
                    client.constructSchemaBlackList((TConstructSchemaBlackListReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((DeleteSchemaRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case ROLLBACK_SCHEMA_BLACK_LIST: {
                    client.rollbackSchemaBlackList((TRollbackSchemaBlackListReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((DeleteSchemaRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case FETCH_SCHEMA_BLACK_LIST: {
                    client.fetchSchemaBlackList((TFetchSchemaBlackListReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((FetchSchemaBlackListRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case INVALIDATE_MATCHED_SCHEMA_CACHE: {
                    client.invalidateMatchedSchemaCache((TInvalidateMatchedSchemaCacheReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case DELETE_DATA_FOR_DELETE_SCHEMA: {
                    client.deleteDataForDeleteSchema((TDeleteDataForDeleteSchemaReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((DeleteSchemaRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case DELETE_TIMESERIES: {
                    client.deleteTimeSeries((TDeleteTimeSeriesReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((DeleteSchemaRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case PRE_CREATE_PIPE: {
                    client.createPipeOnDataNode((TCreatePipeOnDataNodeReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case OPERATE_PIPE: {
                    client.operatePipeOnDataNode((TOperatePipeOnDataNodeReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case ROLLBACK_OPERATE_PIPE: {
                    client.operatePipeOnDataNodeForRollback((TOperatePipeOnDataNodeReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case CONSTRUCT_SCHEMA_BLACK_LIST_WITH_TEMPLATE: {
                    client.constructSchemaBlackListWithTemplate((TConstructSchemaBlackListWithTemplateReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((DeleteSchemaRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case ROLLBACK_SCHEMA_BLACK_LIST_WITH_TEMPLATE: {
                    client.rollbackSchemaBlackListWithTemplate((TRollbackSchemaBlackListWithTemplateReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((DeleteSchemaRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case DEACTIVATE_TEMPLATE: {
                    client.deactivateTemplate((TDeactivateTemplateReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((DeleteSchemaRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case UPDATE_TEMPLATE: {
                    client.updateTemplate((TUpdateTemplateReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case COUNT_PATHS_USING_TEMPLATE: {
                    client.countPathsUsingTemplate((TCountPathsUsingTemplateReq)clientHandler.getRequest(requestId), (AsyncMethodCallback)((CountPathsUsingTemplateRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                case KILL_QUERY_INSTANCE: {
                    client.killQueryInstance((String)clientHandler.getRequest(requestId), (AsyncMethodCallback)((AsyncTSStatusRPCHandler)clientHandler.createAsyncRPCHandler(requestId, targetDataNode)));
                    break;
                }
                default: {
                    LOGGER.error("Unexpected DataNode Request Type: {} when sendAsyncRequestToDataNode", (Object)clientHandler.getRequestType());
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("{} failed on DataNode {}, because {}, retrying {}...", new Object[]{clientHandler.getRequestType(), targetDataNode.getInternalEndPoint(), e.getMessage(), retryCount});
        }
    }

    public void resetClient(TEndPoint endPoint) {
        this.clientManager.clear((Object)endPoint);
    }

    public AsyncDataNodeInternalServiceClient getAsyncClient(TDataNodeLocation targetDataNode) throws ClientManagerException {
        return (AsyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)targetDataNode.getInternalEndPoint());
    }

    public static AsyncDataNodeClientPool getInstance() {
        return ClientPoolHolder.INSTANCE;
    }

    private static class ClientPoolHolder {
        private static final AsyncDataNodeClientPool INSTANCE = new AsyncDataNodeClientPool();

        private ClientPoolHolder() {
        }
    }
}

