/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.utils;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;

public abstract class TsPrimitiveType
implements Serializable {
    public static TsPrimitiveType getByType(TSDataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return new TsBoolean();
            }
            case INT32: {
                return new TsInt();
            }
            case INT64: {
                return new TsLong();
            }
            case FLOAT: {
                return new TsFloat();
            }
            case DOUBLE: {
                return new TsDouble();
            }
            case TEXT: {
                return new TsBinary();
            }
            case VECTOR: {
                return new TsVector();
            }
        }
        throw new UnSupportedDataTypeException("Unsupported data type:" + (Object)((Object)dataType));
    }

    public static TsPrimitiveType getByType(TSDataType dataType, Object v) {
        switch (dataType) {
            case BOOLEAN: {
                return new TsBoolean((Boolean)v);
            }
            case INT32: {
                return new TsInt((Integer)v);
            }
            case INT64: {
                return new TsLong((Long)v);
            }
            case FLOAT: {
                return new TsFloat(((Float)v).floatValue());
            }
            case DOUBLE: {
                return new TsDouble((Double)v);
            }
            case TEXT: {
                return new TsBinary((Binary)v);
            }
            case VECTOR: {
                return new TsVector((TsPrimitiveType[])v);
            }
        }
        throw new UnSupportedDataTypeException("Unsupported data type:" + (Object)((Object)dataType));
    }

    public boolean getBoolean() {
        throw new UnsupportedOperationException("getBoolean() is not supported for current sub-class");
    }

    public int getInt() {
        throw new UnsupportedOperationException("getInt() is not supported for current sub-class");
    }

    public long getLong() {
        throw new UnsupportedOperationException("getLong() is not supported for current sub-class");
    }

    public float getFloat() {
        throw new UnsupportedOperationException("getFloat() is not supported for current sub-class");
    }

    public double getDouble() {
        throw new UnsupportedOperationException("getDouble() is not supported for current sub-class");
    }

    public Binary getBinary() {
        throw new UnsupportedOperationException("getBinary() is not supported for current sub-class");
    }

    public TsPrimitiveType[] getVector() {
        throw new UnsupportedOperationException("getVector() is not supported for current sub-class");
    }

    public void setBoolean(boolean val) {
        throw new UnsupportedOperationException("setBoolean() is not supported for current sub-class");
    }

    public void setInt(int val) {
        throw new UnsupportedOperationException("setInt() is not supported for current sub-class");
    }

    public void setLong(long val) {
        throw new UnsupportedOperationException("setLong() is not supported for current sub-class");
    }

    public void setFloat(float val) {
        throw new UnsupportedOperationException("setFloat() is not supported for current sub-class");
    }

    public void setDouble(double val) {
        throw new UnsupportedOperationException("setDouble() is not supported for current sub-class");
    }

    public void setBinary(Binary val) {
        throw new UnsupportedOperationException("setBinary() is not supported for current sub-class");
    }

    public void setVector(TsPrimitiveType[] val) {
        throw new UnsupportedOperationException("setVector() is not supported for current sub-class");
    }

    public abstract void setObject(Object var1);

    public abstract void reset();

    public abstract int getSize();

    public abstract Object getValue();

    public abstract String getStringValue();

    public abstract TSDataType getDataType();

    public String toString() {
        return this.getStringValue();
    }

    public boolean equals(Object object) {
        return object instanceof TsPrimitiveType && ((TsPrimitiveType)object).getValue().equals(this.getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public static class TsVector
    extends TsPrimitiveType {
        private TsPrimitiveType[] values;

        public TsVector() {
        }

        public TsVector(TsPrimitiveType[] values) {
            this.values = values;
        }

        @Override
        public TsPrimitiveType[] getVector() {
            return this.values;
        }

        @Override
        public void setVector(TsPrimitiveType[] vals) {
            this.values = vals;
        }

        @Override
        public void setObject(Object val) {
            if (val instanceof TsPrimitiveType[]) {
                this.setVector((TsPrimitiveType[])val);
                return;
            }
            throw new UnSupportedDataTypeException("TsVector can only be set TsPrimitiveType[] value");
        }

        @Override
        public void reset() {
            this.values = null;
        }

        @Override
        public int getSize() {
            int size = 0;
            for (TsPrimitiveType type : this.values) {
                if (type == null) continue;
                size += type.getSize();
            }
            return 8 + size;
        }

        @Override
        public Object getValue() {
            return this.getVector();
        }

        @Override
        public String getStringValue() {
            StringBuilder builder = new StringBuilder("[");
            builder.append(this.values[0] == null ? "null" : this.values[0].getStringValue());
            for (int i = 1; i < this.values.length; ++i) {
                builder.append(", ").append(this.values[i] == null ? "null" : this.values[i].getStringValue());
            }
            builder.append("]");
            return builder.toString();
        }

        @Override
        public TSDataType getDataType() {
            return TSDataType.VECTOR;
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.values);
        }

        @Override
        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof TsVector) {
                TsVector anotherTs = (TsVector)anObject;
                if (anotherTs.values.length != this.values.length) {
                    return false;
                }
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.values[i].equals(anotherTs.values[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static class TsBinary
    extends TsPrimitiveType {
        private Binary value;

        public TsBinary() {
        }

        public TsBinary(Binary value) {
            this.value = value;
        }

        @Override
        public Binary getBinary() {
            return this.value;
        }

        @Override
        public void setBinary(Binary val) {
            this.value = val;
        }

        @Override
        public void setObject(Object val) {
            if (val instanceof Binary) {
                this.setBinary((Binary)val);
                return;
            }
            throw new UnSupportedDataTypeException("TsBinary can only be set Binary value");
        }

        @Override
        public void reset() {
            this.value = null;
        }

        @Override
        public int getSize() {
            return 8 + this.value.getLength();
        }

        @Override
        public Object getValue() {
            return this.getBinary();
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        public TSDataType getDataType() {
            return TSDataType.TEXT;
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof TsBinary) {
                TsBinary anotherTs = (TsBinary)anObject;
                return this.value.equals(anotherTs.value);
            }
            return false;
        }
    }

    public static class TsDouble
    extends TsPrimitiveType {
        private double value;

        public TsDouble() {
        }

        public TsDouble(double value) {
            this.value = value;
        }

        @Override
        public double getDouble() {
            return this.value;
        }

        @Override
        public void setDouble(double val) {
            this.value = val;
        }

        @Override
        public void setObject(Object val) {
            if (val instanceof Double) {
                this.setDouble((Double)val);
                return;
            }
            throw new UnSupportedDataTypeException("TsDouble can only be set Double value");
        }

        @Override
        public void reset() {
            this.value = 0.0;
        }

        @Override
        public int getSize() {
            return 12;
        }

        @Override
        public Object getValue() {
            return this.getDouble();
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        public TSDataType getDataType() {
            return TSDataType.DOUBLE;
        }

        @Override
        public int hashCode() {
            return Double.hashCode(this.value);
        }

        @Override
        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof TsDouble) {
                TsDouble anotherTs = (TsDouble)anObject;
                return this.value == anotherTs.value;
            }
            return false;
        }
    }

    public static class TsFloat
    extends TsPrimitiveType {
        private float value;

        public TsFloat() {
        }

        public TsFloat(float value) {
            this.value = value;
        }

        @Override
        public float getFloat() {
            return this.value;
        }

        @Override
        public void setFloat(float val) {
            this.value = val;
        }

        @Override
        public void setObject(Object val) {
            if (val instanceof Float) {
                this.setFloat(((Float)val).floatValue());
                return;
            }
            throw new UnSupportedDataTypeException("TsFloat can only be set float value");
        }

        @Override
        public void reset() {
            this.value = 0.0f;
        }

        @Override
        public int getSize() {
            return 8;
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.getFloat());
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        public TSDataType getDataType() {
            return TSDataType.FLOAT;
        }

        @Override
        public int hashCode() {
            return Float.hashCode(this.value);
        }

        @Override
        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof TsFloat) {
                TsFloat anotherTs = (TsFloat)anObject;
                return this.value == anotherTs.value;
            }
            return false;
        }
    }

    public static class TsLong
    extends TsPrimitiveType {
        private long value;

        public TsLong() {
        }

        public TsLong(long value) {
            this.value = value;
        }

        @Override
        public long getLong() {
            return this.value;
        }

        @Override
        public void setLong(long val) {
            this.value = val;
        }

        @Override
        public void setObject(Object val) {
            if (val instanceof Long) {
                this.setLong((Long)val);
                return;
            }
            throw new UnSupportedDataTypeException("TsLong can only be set Long value");
        }

        @Override
        public void reset() {
            this.value = 0L;
        }

        @Override
        public int getSize() {
            return 12;
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        public TSDataType getDataType() {
            return TSDataType.INT64;
        }

        @Override
        public Object getValue() {
            return this.getLong();
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.value);
        }

        @Override
        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof TsLong) {
                TsLong anotherTs = (TsLong)anObject;
                return this.value == anotherTs.value;
            }
            return false;
        }
    }

    public static class TsInt
    extends TsPrimitiveType {
        private int value;

        public TsInt() {
        }

        public TsInt(int value) {
            this.value = value;
        }

        @Override
        public int getInt() {
            return this.value;
        }

        @Override
        public void setInt(int val) {
            this.value = val;
        }

        @Override
        public void setObject(Object val) {
            if (val instanceof Integer) {
                this.setInt((Integer)val);
                return;
            }
            throw new UnSupportedDataTypeException("TsInt can only be set Integer value");
        }

        @Override
        public void reset() {
            this.value = 0;
        }

        @Override
        public int getSize() {
            return 8;
        }

        @Override
        public Object getValue() {
            return this.getInt();
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        public TSDataType getDataType() {
            return TSDataType.INT32;
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.value);
        }

        @Override
        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof TsInt) {
                TsInt anotherTs = (TsInt)anObject;
                return this.value == anotherTs.value;
            }
            return false;
        }
    }

    public static class TsBoolean
    extends TsPrimitiveType {
        private boolean value;

        public TsBoolean() {
        }

        public TsBoolean(boolean value) {
            this.value = value;
        }

        @Override
        public boolean getBoolean() {
            return this.value;
        }

        @Override
        public void setBoolean(boolean val) {
            this.value = val;
        }

        @Override
        public void setObject(Object val) {
            if (val instanceof Boolean) {
                this.setBoolean((Boolean)val);
                return;
            }
            throw new UnSupportedDataTypeException("TsBoolean can only be set Boolean value");
        }

        @Override
        public void reset() {
            this.value = false;
        }

        @Override
        public int getSize() {
            return 5;
        }

        @Override
        public Object getValue() {
            return this.getBoolean();
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        public TSDataType getDataType() {
            return TSDataType.BOOLEAN;
        }

        @Override
        public int hashCode() {
            return Boolean.hashCode(this.value);
        }

        @Override
        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof TsBoolean) {
                TsBoolean anotherTs = (TsBoolean)anObject;
                return this.value == anotherTs.value;
            }
            return false;
        }
    }
}

