/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.security.encrypt.AsymmetricEncryptFactory;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TRoleResp;
import org.apache.iotdb.confignode.rpc.thrift.TUserResp;
import org.apache.iotdb.rpc.TSStatusCode;

public class AuthUtils {
    private static final String ROOT_PREFIX = "root";
    public static final String ROOT_PATH_PRIVILEGE = "root.**";
    private static final int MIN_PASSWORD_LENGTH = 4;
    private static final int MIN_USERNAME_LENGTH = 4;
    private static final int MIN_ROLENAME_LENGTH = 4;

    private AuthUtils() {
    }

    public static void validatePassword(String password) throws AuthException {
        if (password.length() < 4) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "Password's size must be greater than or equal to 4");
        }
        if (password.contains(" ")) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "Password cannot contain spaces");
        }
    }

    public static boolean validatePassword(String originPassword, String encryptPassword) {
        return AsymmetricEncryptFactory.getEncryptProvider(CommonDescriptor.getInstance().getConfig().getEncryptDecryptProvider(), CommonDescriptor.getInstance().getConfig().getEncryptDecryptProviderParameter()).validate(originPassword, encryptPassword);
    }

    public static void validateUsername(String username) throws AuthException {
        if (username.length() < 4) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "Username's size must be greater than or equal to 4");
        }
        if (username.contains(" ")) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "Username cannot contain spaces");
        }
    }

    public static void validateRolename(String rolename) throws AuthException {
        if (rolename.length() < 4) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "Role name's size must be greater than or equal to 4");
        }
        if (rolename.contains(" ")) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "Role name cannot contain spaces");
        }
    }

    public static void validatePrivilege(int privilegeId) throws AuthException {
        if (privilegeId < 0 || privilegeId >= PrivilegeType.values().length) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, String.format("Invalid privilegeId %d", privilegeId));
        }
    }

    public static void validatePath(String path) throws AuthException {
        if (!path.startsWith(ROOT_PREFIX)) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, String.format("Illegal seriesPath %s, seriesPath should start with \"%s\"", path, ROOT_PREFIX));
        }
    }

    public static void validatePrivilegeOnPath(String path, int privilegeId) throws AuthException {
        AuthUtils.validatePrivilege(privilegeId);
        PrivilegeType type = PrivilegeType.values()[privilegeId];
        if (!path.equals(ROOT_PATH_PRIVILEGE)) {
            AuthUtils.validatePath(path);
            switch (type) {
                case READ_TIMESERIES: 
                case CREATE_DATABASE: 
                case DELETE_DATABASE: 
                case CREATE_TIMESERIES: 
                case DELETE_TIMESERIES: 
                case INSERT_TIMESERIES: 
                case ALTER_TIMESERIES: 
                case CREATE_TRIGGER: 
                case DROP_TRIGGER: 
                case START_TRIGGER: 
                case STOP_TRIGGER: 
                case APPLY_TEMPLATE: {
                    return;
                }
            }
            throw new AuthException(TSStatusCode.UNKNOWN_AUTH_PRIVILEGE, String.format("Illegal privilege %s on seriesPath %s", new Object[]{type, path}));
        }
        switch (type) {
            case READ_TIMESERIES: 
            case CREATE_DATABASE: 
            case DELETE_DATABASE: 
            case CREATE_TIMESERIES: 
            case DELETE_TIMESERIES: 
            case INSERT_TIMESERIES: 
            case ALTER_TIMESERIES: {
                AuthUtils.validatePath(path);
                return;
            }
        }
    }

    public static String encryptPassword(String password) {
        return AsymmetricEncryptFactory.getEncryptProvider(CommonDescriptor.getInstance().getConfig().getEncryptDecryptProvider(), CommonDescriptor.getInstance().getConfig().getEncryptDecryptProviderParameter()).encrypt(password);
    }

    public static boolean pathBelongsTo(String pathA, String pathB) throws AuthException {
        try {
            PartialPath partialPathA = new PartialPath(pathA);
            PartialPath partialPathB = new PartialPath(pathB);
            return partialPathB.matchFullPath(partialPathA);
        }
        catch (IllegalPathException e) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, (Throwable)e);
        }
    }

    public static boolean checkPrivilege(String path, int privilegeId, List<PathPrivilege> privilegeList) throws AuthException {
        if (privilegeList == null) {
            return false;
        }
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!(path != null ? pathPrivilege.getPath() != null && AuthUtils.pathBelongsTo(path, pathPrivilege.getPath()) && pathPrivilege.getPrivileges().contains(privilegeId) : pathPrivilege.getPath() == null && pathPrivilege.getPrivileges().contains(privilegeId))) continue;
            return true;
        }
        return false;
    }

    public static Set<Integer> getPrivileges(String path, List<PathPrivilege> privilegeList) throws AuthException {
        if (privilegeList == null) {
            return new HashSet<Integer>();
        }
        HashSet<Integer> privileges = new HashSet<Integer>();
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (path != null) {
                if (pathPrivilege.getPath() == null || !AuthUtils.pathBelongsTo(path, pathPrivilege.getPath())) continue;
                privileges.addAll(pathPrivilege.getPrivileges());
                continue;
            }
            if (pathPrivilege.getPath() != null) continue;
            privileges.addAll(pathPrivilege.getPrivileges());
        }
        return privileges;
    }

    public static boolean hasPrivilege(String path, int privilegeId, List<PathPrivilege> privilegeList) {
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().equals(path) || !pathPrivilege.getPrivileges().contains(privilegeId)) continue;
            pathPrivilege.getReferenceCnt().incrementAndGet();
            return true;
        }
        return false;
    }

    public static void addPrivilege(String path, int privilegeId, List<PathPrivilege> privilegeList) {
        PathPrivilege targetPathPrivilege = null;
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().equals(path)) continue;
            targetPathPrivilege = pathPrivilege;
            break;
        }
        if (targetPathPrivilege == null) {
            targetPathPrivilege = new PathPrivilege(path);
            privilegeList.add(targetPathPrivilege);
        }
        if (privilegeId != PrivilegeType.ALL.ordinal()) {
            targetPathPrivilege.getPrivileges().add(privilegeId);
        } else {
            for (PrivilegeType privilegeType : PrivilegeType.values()) {
                targetPathPrivilege.getPrivileges().add(privilegeType.ordinal());
            }
        }
    }

    public static void removePrivilege(String path, int privilegeId, List<PathPrivilege> privilegeList) {
        PathPrivilege targetPathPrivilege = null;
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().equals(path)) continue;
            targetPathPrivilege = pathPrivilege;
            break;
        }
        if (targetPathPrivilege != null) {
            if (privilegeId == PrivilegeType.ALL.ordinal()) {
                privilegeList.remove(targetPathPrivilege);
            } else {
                targetPathPrivilege.getPrivileges().remove(privilegeId);
                if (targetPathPrivilege.getPrivileges().isEmpty()) {
                    privilegeList.remove(targetPathPrivilege);
                }
            }
        }
    }

    public static TPermissionInfoResp generateEmptyPermissionInfoResp() {
        TPermissionInfoResp permissionInfoResp = new TPermissionInfoResp();
        permissionInfoResp.setUserInfo(new TUserResp("", "", new ArrayList(), new ArrayList(), false));
        HashMap<String, TRoleResp> roleInfo = new HashMap<String, TRoleResp>();
        roleInfo.put("", new TRoleResp("", new ArrayList()));
        permissionInfoResp.setRoleInfo(roleInfo);
        return permissionInfoResp;
    }

    public static Set<Integer> strToPermissions(String[] authorizationList) throws AuthException {
        HashSet<Integer> result = new HashSet<Integer>();
        if (authorizationList == null) {
            return result;
        }
        PrivilegeType[] types = PrivilegeType.values();
        for (String authorization : authorizationList) {
            boolean legal = false;
            if ("SET_STORAGE_GROUP".equalsIgnoreCase(authorization)) {
                authorization = PrivilegeType.CREATE_DATABASE.name();
            }
            if ("DELETE_STORAGE_GROUP".equalsIgnoreCase(authorization)) {
                authorization = PrivilegeType.DELETE_DATABASE.name();
            }
            for (PrivilegeType privilegeType : types) {
                if (!authorization.equalsIgnoreCase(privilegeType.name())) continue;
                result.add(privilegeType.ordinal());
                legal = true;
                break;
            }
            if (legal) continue;
            throw new AuthException(TSStatusCode.UNKNOWN_AUTH_PRIVILEGE, "No such privilege " + authorization);
        }
        return result;
    }
}

