/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.sync.pipesink;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.confignode.rpc.thrift.TPipeSinkInfo;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class IoTDBPipeSink
implements PipeSink {
    private static final PipeSink.PipeSinkType pipeSinkType = PipeSink.PipeSinkType.IoTDB;
    private String name;
    private String ip;
    private int port;
    private static final String ATTRIBUTE_IP_KEY = "ip";
    private static final String ATTRIBUTE_PORT_KEY = "port";

    public IoTDBPipeSink() {
    }

    public IoTDBPipeSink(String name) {
        this();
        this.ip = "127.0.0.1";
        this.port = 6667;
        this.name = name;
    }

    @Override
    public void setAttribute(Map<String, String> params) throws PipeSinkException {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String attr = entry.getKey();
            String value = entry.getValue();
            if ((attr = attr.toLowerCase()).equals(ATTRIBUTE_IP_KEY)) {
                if (!Pattern.matches("^([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}$", value)) {
                    throw new PipeSinkException(String.format("%s is nonstandard IP address, only support IPv4 now.", value));
                }
                this.ip = value;
                continue;
            }
            if (attr.equals(ATTRIBUTE_PORT_KEY)) {
                try {
                    this.port = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new PipeSinkException(attr, value, TSDataType.INT32.name());
                }
            }
            throw new PipeSinkException("There is No attribute " + attr + " in " + (Object)((Object)PipeSink.PipeSinkType.IoTDB) + " pipeSink.");
        }
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public String getPipeSinkName() {
        return this.name;
    }

    @Override
    public PipeSink.PipeSinkType getType() {
        return pipeSinkType;
    }

    @Override
    public String showAllAttributes() {
        return String.format("%s='%s',%s=%d", ATTRIBUTE_IP_KEY, this.ip, ATTRIBUTE_PORT_KEY, this.port);
    }

    @Override
    public TPipeSinkInfo getTPipeSinkInfo() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(ATTRIBUTE_IP_KEY, this.ip);
        attributes.put(ATTRIBUTE_PORT_KEY, String.valueOf(this.port));
        return new TPipeSinkInfo(this.name, pipeSinkType.name()).setAttributes(attributes);
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)((byte)pipeSinkType.ordinal()), (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.name, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.ip, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.port, (OutputStream)outputStream);
    }

    @Override
    public void deserialize(InputStream inputStream) throws IOException {
        this.name = ReadWriteIOUtils.readString((InputStream)inputStream);
        this.ip = ReadWriteIOUtils.readString((InputStream)inputStream);
        this.port = ReadWriteIOUtils.readInt((InputStream)inputStream);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.name = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.ip = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.port = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
    }

    public String toString() {
        return "IoTDBPipeSink{pipeSinkType=" + (Object)((Object)pipeSinkType) + ", name='" + this.name + '\'' + ", ip='" + this.ip + '\'' + ", port=" + this.port + '}';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) return false;
        if (this.getClass() != o.getClass()) {
            return false;
        }
        IoTDBPipeSink pipeSink = (IoTDBPipeSink)o;
        if (this.port != pipeSink.port) return false;
        if (pipeSinkType != pipeSinkType) return false;
        if (!Objects.equals(this.name, pipeSink.name)) return false;
        if (!Objects.equals(this.ip, pipeSink.ip)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{pipeSinkType, this.name, this.ip, this.port});
    }
}

