/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.sync.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.SyncOperation;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SyncLogWriter
implements AutoCloseable {
    private OutputStream outputStream;
    private final File dir;
    private final String fileName;

    public SyncLogWriter(File dir) {
        this.dir = dir;
        this.fileName = "syncService.log";
    }

    public SyncLogWriter(File dir, String fileName) {
        this.dir = dir;
        this.fileName = fileName;
    }

    public void initOutputStream() throws IOException {
        if (this.outputStream == null) {
            File logFile = new File(this.dir, this.fileName);
            if (!logFile.getParentFile().exists()) {
                logFile.getParentFile().mkdirs();
            }
            this.outputStream = new FileOutputStream(logFile, true);
        }
    }

    public synchronized void addPipeSink(PipeSink pipeSink) throws IOException {
        this.initOutputStream();
        ReadWriteIOUtils.write((byte)((byte)SyncOperation.CREATE_PIPESINK.ordinal()), (OutputStream)this.outputStream);
        pipeSink.serialize(this.outputStream);
    }

    public synchronized void dropPipeSink(String pipeSinkName) throws IOException {
        this.initOutputStream();
        ReadWriteIOUtils.write((byte)((byte)SyncOperation.DROP_PIPESINK.ordinal()), (OutputStream)this.outputStream);
        ReadWriteIOUtils.write((String)pipeSinkName, (OutputStream)this.outputStream);
    }

    public synchronized void addPipe(PipeInfo pipeInfo) throws IOException {
        this.initOutputStream();
        ReadWriteIOUtils.write((byte)((byte)SyncOperation.CREATE_PIPE.ordinal()), (OutputStream)this.outputStream);
        pipeInfo.serialize(this.outputStream);
    }

    public synchronized void operatePipe(String pipeName, SyncOperation syncOperation) throws IOException {
        this.initOutputStream();
        ReadWriteIOUtils.write((byte)((byte)syncOperation.ordinal()), (OutputStream)this.outputStream);
        ReadWriteIOUtils.write((String)pipeName, (OutputStream)this.outputStream);
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
    }
}

