/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.leader.LogAppender;

class ReadRequests {
    ReadRequests() {
    }

    static class HeartbeatAck {
        private final LogAppender appender;
        private final long minCallId;
        private volatile boolean acknowledged = false;

        HeartbeatAck(LogAppender appender) {
            this.appender = appender;
            this.minCallId = appender.getCallId();
        }

        boolean isAcknowledged() {
            return this.acknowledged;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean receive(RaftProtos.AppendEntriesReplyProto reply) {
            if (this.acknowledged) {
                return false;
            }
            HeartbeatAck heartbeatAck = this;
            synchronized (heartbeatAck) {
                if (!this.acknowledged && this.isValid(reply)) {
                    this.acknowledged = true;
                    return true;
                }
                return false;
            }
        }

        private boolean isValid(RaftProtos.AppendEntriesReplyProto reply) {
            if (reply == null || !reply.getServerReply().getSuccess()) {
                return false;
            }
            return this.appender.getCallIdComparator().compare(reply.getServerReply().getCallId(), this.minCallId) >= 0;
        }
    }
}

