/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.server.leader.FollowerInfo;
import org.apache.ratis.server.raftlog.RaftLogIndex;
import org.apache.ratis.util.Timestamp;

class FollowerInfoImpl
implements FollowerInfo {
    private final String name;
    private final Consumer<Object> infoIndexChange;
    private final Consumer<Object> debugIndexChange;
    private final RaftPeer peer;
    private final AtomicReference<Timestamp> lastRpcResponseTime;
    private final AtomicReference<Timestamp> lastRpcSendTime;
    private final AtomicReference<Timestamp> lastHeartbeatSendTime;
    private final RaftLogIndex nextIndex;
    private final RaftLogIndex matchIndex = new RaftLogIndex((Object)"matchIndex", -1L);
    private final RaftLogIndex commitIndex = new RaftLogIndex((Object)"commitIndex", -1L);
    private final RaftLogIndex snapshotIndex = new RaftLogIndex((Object)"snapshotIndex", 0L);
    private volatile boolean attendVote;
    private volatile boolean ackInstallSnapshotAttempt = false;

    FollowerInfoImpl(RaftGroupMemberId id, RaftPeer peer, Timestamp lastRpcTime, long nextIndex, boolean attendVote) {
        this.name = id + "->" + peer.getId();
        this.infoIndexChange = s -> LOG.info("{}: {}", (Object)this.name, s);
        this.debugIndexChange = s -> LOG.debug("{}: {}", (Object)this.name, s);
        this.peer = peer;
        this.lastRpcResponseTime = new AtomicReference<Timestamp>(lastRpcTime);
        this.lastRpcSendTime = new AtomicReference<Timestamp>(lastRpcTime);
        this.lastHeartbeatSendTime = new AtomicReference<Timestamp>(lastRpcTime);
        this.nextIndex = new RaftLogIndex((Object)"nextIndex", nextIndex);
        this.attendVote = attendVote;
    }

    public long getMatchIndex() {
        return this.matchIndex.get();
    }

    public boolean updateMatchIndex(long newMatchIndex) {
        return this.matchIndex.updateToMax(newMatchIndex, this.debugIndexChange);
    }

    public long getCommitIndex() {
        return this.commitIndex.get();
    }

    public boolean updateCommitIndex(long newCommitIndex) {
        return this.commitIndex.updateToMax(newCommitIndex, this.debugIndexChange);
    }

    public long getSnapshotIndex() {
        return this.snapshotIndex.get();
    }

    public long getNextIndex() {
        return this.nextIndex.get();
    }

    public void increaseNextIndex(long newNextIndex) {
        this.nextIndex.updateIncreasingly(newNextIndex, this.debugIndexChange);
    }

    public void decreaseNextIndex(long newNextIndex) {
        this.nextIndex.updateUnconditionally(old -> old <= 0L ? old : Math.min(old - 1L, newNextIndex), this.infoIndexChange);
    }

    public void setNextIndex(long newNextIndex) {
        this.nextIndex.updateUnconditionally(old -> newNextIndex >= 0L ? newNextIndex : old, this.infoIndexChange);
    }

    public void updateNextIndex(long newNextIndex) {
        this.nextIndex.updateToMax(newNextIndex, this.infoIndexChange);
    }

    public void setSnapshotIndex(long newSnapshotIndex) {
        this.snapshotIndex.setUnconditionally(newSnapshotIndex, this.infoIndexChange);
        this.matchIndex.setUnconditionally(newSnapshotIndex, this.infoIndexChange);
        this.nextIndex.setUnconditionally(newSnapshotIndex + 1L, this.infoIndexChange);
    }

    public void setAttemptedToInstallSnapshot() {
        LOG.info("Follower {} acknowledged installing snapshot", (Object)this.name);
        this.ackInstallSnapshotAttempt = true;
    }

    public boolean hasAttemptedToInstallSnapshot() {
        return this.ackInstallSnapshotAttempt;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + "(c" + this.getCommitIndex() + ",m" + this.getMatchIndex() + ",n" + this.getNextIndex() + ", attendVote=" + this.attendVote + ", lastRpcSendTime=" + this.lastRpcSendTime.get().elapsedTimeMs() + ", lastRpcResponseTime=" + this.lastRpcResponseTime.get().elapsedTimeMs() + ")";
    }

    void startAttendVote() {
        this.attendVote = true;
    }

    boolean isAttendingVote() {
        return this.attendVote;
    }

    public RaftPeer getPeer() {
        return this.peer;
    }

    public void updateLastRpcResponseTime() {
        this.lastRpcResponseTime.set(Timestamp.currentTime());
    }

    public Timestamp getLastRpcResponseTime() {
        return this.lastRpcResponseTime.get();
    }

    public void updateLastRpcSendTime(boolean isHeartbeat) {
        Timestamp currentTime = Timestamp.currentTime();
        this.lastRpcSendTime.set(currentTime);
        if (isHeartbeat) {
            this.lastHeartbeatSendTime.set(currentTime);
        }
    }

    public Timestamp getLastRpcTime() {
        return Timestamp.latest((Timestamp)this.lastRpcResponseTime.get(), (Timestamp)this.lastRpcSendTime.get());
    }

    public Timestamp getLastHeartbeatSendTime() {
        return this.lastHeartbeatSendTime.get();
    }
}

