/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.query.control.QueryFileManager;
import org.apache.iotdb.db.service.TemporaryQueryDataFileService;

public class QueryResourceManager {
    private final AtomicLong queryIdAtom = new AtomicLong();
    private final QueryFileManager filePathsManager = new QueryFileManager();

    private QueryResourceManager() {
    }

    public static QueryResourceManager getInstance() {
        return QueryTokenManagerHelper.INSTANCE;
    }

    public long assignQueryId() {
        return this.queryIdAtom.incrementAndGet();
    }

    public long assignCompactionQueryId() {
        long threadNum = Long.parseLong(Thread.currentThread().getName().split("-")[4]);
        long queryId = Long.MIN_VALUE + threadNum;
        this.filePathsManager.addQueryId(queryId);
        return queryId;
    }

    public void endQuery(long queryId) {
        this.filePathsManager.removeUsedFilesForQuery(queryId);
        TemporaryQueryDataFileService.getInstance().deregister(queryId);
    }

    public QueryFileManager getQueryFileManager() {
        return this.filePathsManager;
    }

    private static class QueryTokenManagerHelper {
        private static final QueryResourceManager INSTANCE = new QueryResourceManager();

        private QueryTokenManagerHelper() {
        }
    }
}

