/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.iotdb.db.protocol.influxdb.meta.IInfluxDBMetaManager;
import org.apache.iotdb.db.protocol.influxdb.util.QueryResultUtils;
import org.apache.iotdb.db.protocol.influxdb.util.StringUtils;
import org.apache.iotdb.db.service.thrift.impl.NewInfluxDBServiceImpl;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;

public class TagInfluxDBMetaManager
implements IInfluxDBMetaManager {
    private static final String STORAGE_GROUP_PATH = "root.influxdbmeta";
    private static final String TAGS_SET = "set.tags";
    private static final String FIELDS_SET = "set.fields";

    private TagInfluxDBMetaManager() {
    }

    public static TagInfluxDBMetaManager getInstance() {
        return TagInfluxDBMetaManagerHolder.INSTANCE;
    }

    @Override
    public void recover() {
    }

    @Override
    public Map<String, Integer> getFieldOrders(String database, String measurement, long sessionId) {
        return this.getTimeseriesFieldOrders(database, measurement, FIELDS_SET, sessionId);
    }

    @Override
    public String generatePath(String database, String measurement, Map<String, String> tags, Set<String> fields, long sessionID) {
        this.createInfluxDBMetaTimeseries(database, measurement, tags, fields, sessionID);
        return this.generateDevicesPath(database, measurement, tags);
    }

    private void createInfluxDBMetaTimeseries(String database, String measurement, Map<String, String> tags, Set<String> fields, long sessionID) {
        ArrayList<String> fieldsList = new ArrayList<String>(tags.keySet());
        this.createInfluxDBMetaTimeseries(database, measurement, TAGS_SET, fieldsList, sessionID);
        fieldsList.clear();
        fieldsList.addAll(fields);
        this.createInfluxDBMetaTimeseries(database, measurement, FIELDS_SET, fieldsList, sessionID);
    }

    private void createInfluxDBMetaTimeseries(String database, String measurement, String device, List<String> fields, long sessionID) {
        String statement = this.generateTimeseriesStatement(database, measurement, device, fields);
        NewInfluxDBServiceImpl.executeStatement(statement, sessionID);
    }

    private String generateTimeseriesStatement(String database, String measurement, String device, List<String> fields) {
        StringBuilder timeseriesStatement = new StringBuilder("create aligned timeseries root.influxdbmeta.database." + database + ".measurement." + measurement + "." + device + "(");
        for (int i = 0; i < fields.size() - 1; ++i) {
            String field = fields.get(i);
            timeseriesStatement.append(field).append(" BOOLEAN, ");
        }
        timeseriesStatement.append(fields.get(fields.size() - 1)).append(" BOOLEAN)");
        return timeseriesStatement.toString();
    }

    @Override
    public Map<String, Integer> getTagOrders(String database, String measurement, long sessionID) {
        return this.getTimeseriesFieldOrders(database, measurement, TAGS_SET, sessionID);
    }

    private Map<String, Integer> getTimeseriesFieldOrders(String database, String measurement, String device, long sessionID) {
        TSExecuteStatementResp statementResp = NewInfluxDBServiceImpl.executeStatement("show timeseries root.influxdbmeta.database." + database + ".measurement." + measurement + "." + device, sessionID);
        List<String> timeseriesPaths = QueryResultUtils.getFullPaths(statementResp);
        HashMap<String, Integer> fieldOrders = new HashMap<String, Integer>();
        for (String timeseriesPath : timeseriesPaths) {
            String field = StringUtils.getFieldByPath(timeseriesPath);
            fieldOrders.put(field, fieldOrders.size());
        }
        return fieldOrders;
    }

    private String generateDevicesPath(String database, String measurement, Map<String, String> tags) {
        TreeMap<String, String> tagsMap = new TreeMap<String, String>(tags);
        tagsMap.put("measurement", measurement);
        StringBuilder devicePath = new StringBuilder("root." + database);
        for (String tagKey : tagsMap.keySet()) {
            devicePath.append(".").append(tagKey).append(".").append(tagsMap.get(tagKey));
        }
        return devicePath.toString();
    }

    private static class TagInfluxDBMetaManagerHolder {
        private static final TagInfluxDBMetaManager INSTANCE = new TagInfluxDBMetaManager();

        private TagInfluxDBMetaManagerHolder() {
        }
    }
}

