/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import io.airlift.units.Duration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.execution.QueryStateMachine;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInfo;
import org.apache.iotdb.db.mpp.metric.QueryMetricsManager;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.scheduler.FixedRateFragInsStateTracker;
import org.apache.iotdb.db.mpp.plan.scheduler.FragInstanceDispatchResult;
import org.apache.iotdb.db.mpp.plan.scheduler.FragmentInstanceDispatcherImpl;
import org.apache.iotdb.db.mpp.plan.scheduler.IFragInstanceDispatcher;
import org.apache.iotdb.db.mpp.plan.scheduler.IFragInstanceStateTracker;
import org.apache.iotdb.db.mpp.plan.scheduler.IQueryTerminator;
import org.apache.iotdb.db.mpp.plan.scheduler.IScheduler;
import org.apache.iotdb.db.mpp.plan.scheduler.SimpleQueryTerminator;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterScheduler
implements IScheduler {
    private static final Logger logger = LoggerFactory.getLogger(ClusterScheduler.class);
    private final QueryStateMachine stateMachine;
    private final QueryType queryType;
    private final List<FragmentInstance> instances;
    private final IFragInstanceDispatcher dispatcher;
    private IFragInstanceStateTracker stateTracker;
    private IQueryTerminator queryTerminator;
    private static final QueryMetricsManager QUERY_METRICS = QueryMetricsManager.getInstance();

    public ClusterScheduler(MPPQueryContext queryContext, QueryStateMachine stateMachine, List<FragmentInstance> instances, QueryType queryType, ExecutorService executor, ExecutorService writeOperationExecutor, ScheduledExecutorService scheduledExecutor, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> syncInternalServiceClientManager, IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager) {
        this.stateMachine = stateMachine;
        this.instances = instances;
        this.queryType = queryType;
        this.dispatcher = new FragmentInstanceDispatcherImpl(queryType, queryContext, executor, writeOperationExecutor, syncInternalServiceClientManager, asyncInternalServiceClientManager);
        if (queryType == QueryType.READ) {
            this.stateTracker = new FixedRateFragInsStateTracker(stateMachine, scheduledExecutor, instances, syncInternalServiceClientManager);
            this.queryTerminator = new SimpleQueryTerminator(scheduledExecutor, queryContext, instances, syncInternalServiceClientManager, this.stateTracker);
        }
    }

    private boolean needRetry(TSStatus failureStatus) {
        return failureStatus != null && this.queryType == QueryType.READ && failureStatus.getCode() == TSStatusCode.DISPATCH_ERROR.getStatusCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        this.stateMachine.transitionToDispatching();
        long startTime = System.nanoTime();
        Future<FragInstanceDispatchResult> dispatchResultFuture = this.dispatcher.dispatch(this.instances);
        try {
            FragInstanceDispatchResult result = dispatchResultFuture.get();
            if (!result.isSuccessful()) {
                if (this.needRetry(result.getFailureStatus())) {
                    this.stateMachine.transitionToPendingRetry(result.getFailureStatus());
                } else {
                    this.stateMachine.transitionToFailed(result.getFailureStatus());
                }
                return;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.stateMachine.transitionToFailed(e);
            return;
        }
        finally {
            QUERY_METRICS.recordExecutionCost("wait_for_dispatch", System.nanoTime() - startTime);
        }
        if (this.queryType == QueryType.WRITE) {
            this.stateMachine.transitionToFinished();
            return;
        }
        this.stateMachine.transitionToRunning();
        this.stateTracker.start();
        logger.debug("state tracker starts");
    }

    @Override
    public void stop() {
        this.dispatcher.abort();
        if (this.stateTracker != null) {
            this.stateTracker.abort();
        }
        if (this.queryTerminator != null) {
            this.queryTerminator.terminate();
        }
    }

    @Override
    public Duration getTotalCpuTime() {
        return null;
    }

    @Override
    public FragmentInfo getFragmentInfo() {
        return null;
    }

    @Override
    public void abortFragmentInstance(FragmentInstanceId instanceId, Throwable failureCause) {
    }

    @Override
    public void cancelFragment(PlanFragmentId planFragmentId) {
    }

    private void sendFragmentInstances() {
    }

    private void startMonitorInstances() {
    }
}

